% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_MRF_covariates_spatial.R
\name{prep_MRF_covariates_spatial}
\alias{prep_MRF_covariates_spatial}
\title{Cross-multiply response and covariate variables and build spatial splines}
\usage{
prep_MRF_covariates_spatial(data, n_nodes, coords)
}
\arguments{
\item{data}{Dataframe. The input data where the \code{n_nodes}
left-most variables are outcome variables to be represented by nodes in the graph}

\item{n_nodes}{Integer. The index of the last column in data
which is represented by a node in the final graph. Columns with index
greater than n_nodes are taken as covariates. Default is the number of
columns in data, corresponding to no additional covariates}

\item{coords}{A two-column \code{dataframe} (with \code{nrow(coords) == nrow(data)})
representing the spatial coordinates of each observation in \code{data}. Ideally, these
coordinates will represent Latitude and Longitude GPS points for each observation. The coordinates
are used to create smoothed Gaussian Process spatial regression splines via
\code{\link[mgcv]{smooth.construct2}}.
Here, the basis dimension of the smoothed term
is chosen based on the number of unique GPS coordinates in \code{coords}.
If this number is less than \code{100}, then this number is used. If the number of
unique coordiantes is more than \code{100}, a value of \code{100} is used
(this parameter needs to be large in order to ensure enough degrees of freedom
for estimating 'wiggliness' of the smooth term; see
\code{\link[mgcv]{choose.k}} for details).}
}
\value{
Dataframe of the prepped response and covariate variables necessary for
input in \code{\link{MRFcov_spatial}} models
}
\description{
This function performs the cross-multiplication necessary
for prepping datasets to be used in \code{\link{MRFcov_spatial}} models.
}
\details{
Observations of nodes (species) in \code{data} are prepped for
\code{MRFcov_spatial} analysis by multiplication. This function is useful if
users wish to prep the spatial splines beforehand and split the
data manually for out-of-sample cross-validation. To do so,
prep the splines here and set \code{prep_splines = FALSE} in \code{MRFcov_spatial}
}
