% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetTally.R
\name{quartetTableResolved}
\alias{quartetTableResolved}
\title{Modify quartet table to show only resolved quartets}
\usage{
quartetTableResolved(qt, omit = FALSE)
}
\arguments{
\item{qt}{table, as produced by \code{quartetTable} for \code{n} taxa, with \code{n+4} columns}

\item{omit}{\code{TRUE} deletes unresolved quartets column;
\code{FALSE} deletes the column but redistributes unresolved counts as (1/3,1/3,1/3) to resolved counts}
}
\value{
a table of quartet counts similar to \code{qt}, but with columns showing only resolved quartet counts
}
\description{
Converts table of all quartet counts, including unresolved ones, 
by either dropping unresolved ones, or distributing them uniformly 
among the three resolved counts.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
QT=quartetTable(gtrees,tnames[1:6])
QT[1:6,]
RQT=quartetTableResolved(QT)
RQT[1:6,]

}
\seealso{
\code{\link{quartetTable}}, \code{\link{quartetTableDominant}}
}
