% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTA.R
\name{diagnosis.MTA}
\alias{diagnosis.MTA}
\title{Diagnosis method for the Mahalanobis-Taguchi Adjoint (MTA) method}
\usage{
\method{diagnosis}{MTA}(unit_space, newdata, threshold,
  includes_transformed_newdata = FALSE)
}
\arguments{
\item{unit_space}{Object of class "MTA" generated by \code{\link{MTA}} or
\code{\link{generates_unit_space}}(..., method = "MTA").}

\item{newdata}{Matrix with n rows (samples) and p columns (variables). The
data are used to calculate the desired distances from the
unit space. All data should be continuous values and should
not have missing values.}

\item{threshold}{Numeric specifying the threshold value to classify each
sample into positive (\code{TRUE}) or negative
(\code{FALSE}).}

\item{includes_transformed_newdata}{If \code{TRUE}, then the transformed data
for \code{newdata} are included in a
return object.}
}
\value{
\code{diagnosis.MTA} (via \code{\link{diagnosis}}) returns a list
          containing the following components:

 \item{distance}{Vector with length n. Distances from the unit space to each
                  sample.}
 \item{le_threshold}{Vector with length n. Logical values indicating the
                      distance of each sample is less than or equal to the
                      threhold value (\code{TRUE}) or not (\code{FALSE}).}
 \item{threshold}{Numeric value to classify the sample into positive or
                   negative.}
 \item{unit_space}{Object of class "MTA" passed by \code{unit_space}.}
 \item{n}{The number of samples for \code{newdata}.}
 \item{q}{The number of variables after the data transformation. q equals p.}
 \item{x}{If \code{includes_transformed_newdata} is \code{TRUE}, then the
           transformed data for \code{newdata} are included.}
}
\description{
\code{diagnosis.MTA} (via \code{\link{diagnosis}}) calculates the distance
  based on the unit space generated by \code{\link{MTA}} or
  \code{\link{generates_unit_space}}(..., method = "MTA") and classifies each
  sample into positive (\code{TRUE}) or negative (\code{FALSE}) by comparing
  the values with the set threshold value.
}
\examples{
# 40 data for versicolor in the iris dataset
iris_versicolor <- iris[61:100, -5]

unit_space_MTA <- MTA(unit_space_data = iris_versicolor,
                      includes_transformed_data = TRUE)

# 10 data for each kind (setosa, versicolor, virginica) in the iris dataset
iris_test <- iris[c(1:10, 51:60, 101:111), -5]

diagnosis_MTA <- diagnosis(unit_space = unit_space_MTA,
                           newdata = iris_test,
                           threshold = 0.5,
                           includes_transformed_newdata = TRUE)

(diagnosis_MTA$distance)
(diagnosis_MTA$le_threshold)

}
\references{
Taguchi, G. & Kanetaka, T. (2002). \emph{Engineering Technical Development
    in MT System - Lecture on Applied Quality.} Japanese Standards
    Association. (In Japanese)

  Taguchi, G., & Jugulum, R. (2002). \emph{The Mahalanobis-Taguchi strategy:
    A pattern technology system.} John Wiley & Sons.
}
\seealso{
\code{\link{general_diagnosis.MT}} and \code{\link{MTA}}
}

