% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{MaximinInfer}
\alias{MaximinInfer}
\title{The Wrapper function for Maximin inference}
\usage{
MaximinInfer(
  Xlist,
  Ylist,
  loading,
  X.target = NULL,
  cov.target = NULL,
  covariate.shift = TRUE,
  lam.value = c("CV", "CV.min"),
  intercept = TRUE,
  intercept.loading = FALSE,
  delta = 0,
  gen.size = 500,
  threshold = 0,
  alpha = 0.05,
  alpha.thres = 0.01
)
}
\arguments{
\item{Xlist}{list of design matrix for source data, of length \eqn{L}}

\item{Ylist}{list of outcome vector for source data, of length \eqn{L}}

\item{loading}{Loading, of length \eqn{p}}

\item{X.target}{Design matrix for target data, of dimension \eqn{n.target} x \eqn{p} (default = `NULL`)}

\item{cov.target}{Covariance matrix for target data, of dimension \eqn{p} x \eqn{p} (default = `NULL`)}

\item{covariate.shift}{Covariate shifts or not between source and target data (default = `TRUE`)}

\item{lam.value}{The method to be used to obtain Lasso estimator of high-dimensional regression vector for each group}

\item{intercept}{Should intercept be fitted for the initial estimator (default = `TRUE`)}

\item{intercept.loading}{Should intercept be included for the loading (default = `FALSE`)}

\item{delta}{The ridge penalty (Default = 0)}

\item{gen.size}{The generating sample size (Default = 500)}

\item{threshold}{Should generated samples be filtered or not?
If 0, use normal threshold to filter;
if 1, use chi-square threshold to filter;
if 2, do not filter. (Default = 0)}

\item{alpha}{confidence value to construct confidence interval (Default = 0.05)}

\item{alpha.thres}{confidence value to select generated samples (Default = 0.01)}
}
\value{
\item{weight}{The weight vector for groups, of length \eqn{L}}
\item{point}{The point estimator of the linear combination}
\item{mm.effect}{The aggregated maximin effect (coefficients), of length \eqn{p} or \eqn{p+1}}
\item{CI}{Confidence interval for the linear combination}
}
\description{
\code{MaximinInfer} is a wrapper for class \code{Maximin} and the method \code{infer}.
}
\details{
The algorithm implemented scenarios with or without covariate shift. If `cov.target` is specified,
the `X.target` will be ignored; if not, while `X.target` is specified, `cov.target` will be estimated
by `X.target`. If both are not specified, the algorithm will automatically set `covariate.shift` as
`FALSE`.
}
\examples{
## The problem is low-dimensional and we do sampling only 5 times instead of 500 for testings
## heterogenous data and covariates shift
X1 = sample_data$X1
X2 = sample_data$X2
Y1 = sample_data$Y1
Y2 = sample_data$Y2
X.target = sample_data$X.target

## loading
loading = rep(0, 5) # dimension p=5
loading[5] = 1

## call
mmInfer <- MaximinInfer(list(X1, X2), list(Y1, Y2), loading, X.target, gen.size=5)
}
