% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiStatCount.R
\name{MiStatCount}
\alias{MiStatCount}
\title{FDR for microarray gene expression data}
\usage{
MiStatCount(Matrix, specimens)
}
\arguments{
\item{Matrix}{numeric matrix of expression data where each row corresponds to a probe (gene, transcript),
and each column correspondes to a specimen (patient).}

\item{specimens}{factor vector with two levels specifying specimens in the columns of the \code{Matrix}.}
}
\value{
a data frame containing for each probe: mean and sd values for both groups, difference of means,
p-value for T-test and q-value for FDR (False Discovery Rate) correction.
}
\description{
Performs descriptive statistics and FDR (False Discovery Rate) test for microarray expression matrix
}
\details{
This function takes matrix of expression data and performs T-test with FDR correction for two groups
for each probe.
\cr
T-test is a two-sided, two-class with equal variances against the null hypothesis 'mean1=mean2' for each row.
See \code{\link{rowttests}} for details.
}
\examples{
data("IMexpression"); data("IMspecimen") # load data and specimen information
#sampling data and specimen information
ExpData<-MiDataSample(IMexpression, IMspecimen$diagnosis,"ebv", "norm")
Specimens<-MiSpecimenSample(IMspecimen$diagnosis, "ebv", "norm")
#Counting statistics
StatRes<-MiStatCount(ExpData, Specimens)
head(StatRes)

}
\references{
Welch B.L.(1951) On the comparison of several mean values: an alternative approach. Biometrika 38, 330-336.
\url{https://doi.org/10.1093/biomet/38.3-4.330}
}
\seealso{
\code{\link{rowttests}}
}
\author{
Elena N. Filatova
}
