% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_allele_frequency}
\alias{plot_allele_frequency}
\title{plot_allele_frequency}
\usage{
plot_allele_frequency(
  position,
  heteroplasmy_matrix,
  allele_matrix,
  cluster,
  names_allele_qc,
  names_position_qc,
  size_text,
  index
)
}
\arguments{
\item{position}{Character name of the base to plot.}

\item{heteroplasmy_matrix}{Third element returned by \emph{get_heteroplasmy}.}

\item{allele_matrix}{Fourth element returned by \emph{get_heteroplasmy}.}

\item{cluster}{Vector specifying a partition of the samples.}

\item{names_allele_qc}{Character vector with length equal to n_col of
\emph{allele_matrix}. Each element specifies the name of the base and the allele.}

\item{names_position_qc}{Character vector with length equal to n_col of
\emph{allele_matrix}. Each element specifies the name of the base.}

\item{size_text}{Character specifying the size of the text for \emph{gridExtra} function
\emph{grid.arrange})}

\item{index}{Fifth element returned by \emph{get_heteroplasmy}.}
}
\value{
grid.arrange plot of allele frequencies of a specific base
across samples divided according to cluster.
}
\description{
plot_allele_frequency
}
\seealso{
\url{https://cran.r-project.org/package=gridExtra}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
