% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseprobabilities.R
\name{pairwiseprobabilities}
\alias{pairwiseprobabilities}
\title{Pairwise probabilities of Exceedence}
\usage{
pairwiseprobabilities(
  shifts,
  distname = c("normal", "logistic"),
  taylor = FALSE
)
}
\arguments{
\item{shifts}{The offsets for the various populations, under the alternative hypothesis.}

\item{distname}{The distribution of the underlying observations; normal and logistic are currently supported.}

\item{taylor}{Logical flag forcing the approximation of exeedence probabilities using a Taylor series.}
}
\value{
A matrix with as many rows and colums as there are shift parameters.  Row i and column j give the probability of an observation from group j exceeding one from group i.
}
\description{
\code{pairwiseprobabilities} calculates probabilities of one variable exceeding another,
where the variables are independent, and with identical distributions  except for a location shift.
This calculation is useful for power of Mann-Whitney-Wilcoxon, Jonckheere-Terpstra, and Kruskal-Wallis testing.
}
\details{
Probabilities of particular families must be calculated analytically.
}
\examples{
pairwiseprobabilities(c(0,1,2),"normal")
}
