% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myFUN.R
\name{makedata}
\alias{makedata}
\title{Simulates data from the aforementioned model}
\usage{
makedata(n, x, sx, atoms, probs, variances)
}
\arguments{
\item{n}{Number of z-scores to be generated.}

\item{x}{\eqn{n\times}p data matrix. Do not add an additional column of \eqn{1's}.}

\item{sx}{The vector of coefficients for the logistic function. The first entry will be considered as the intercept term by default. Requires compatibility with x. See \strong{Details}.}

\item{atoms}{The vector of means for each component of the mixing distribution.}

\item{probs}{The probability vector for the mixing distribution.}

\item{variances}{The vector of variances for each component of the mixing distribution. Requires compatibility with atoms and probs. See \strong{Details}.}
}
\value{
The output is a list with the following entries:

\item{y}{The vector of simulated z-scores.}

\item{x}{The input data matrix.}

\item{pix}{The vector of signal proportions.}

\item{f0y}{The vector of standard Gaussian densities evaluated at simulated z-scores.}

\item{f1y}{The vector of signal densities evaluated at simulated z-scores.}

\item{den}{The vector of conditional densities evaluated at simulated z-scores.}

\item{localfdr}{The vector of local false discovery rates evaluated at simulated z-scores. Note that the local FDR can be interpreted as one minus the posterior probability that a given observation is non-null.}

\item{ll}{The average conditional log-likelihood.}

\item{nnind}{The indices corresponding to non-null observations.}
}
\description{
This function can be used to simulate observations from the aforementioned model, if
\eqn{G(\cdot)} is chosen as a finite Gaussian mixture. It returns the true local
false discovery rates which determine the optimal multiple testing procedure.
}
\details{
Given \eqn{X=x}, a Bernoulli\eqn{(\pi^*(x))} sample is drawn. If the outcome is
1 (0), a z-score is drawn from \eqn{\phi_1(\cdot)} \eqn{(\phi(\cdot))}. All the observations
corresponding to a Bernoulli outcome 1 (0) are termed as \emph{non-null observations}
(\emph{null observations}).\cr
The length of sx should be 1 more than the number of columns of the data matrix x.\cr
The vectors - atoms, probs and variances must have the same length.
}
\examples{

x=cbind(runif(1000),runif(1000))
n=1000
atoms=c(-2,0,2)
probs=c(0.48,0.04,0.48)
variances=c(1,16,1)
sx=c(-3,1.5,1.5)
### Generating the data ###
st=makedata(n,x,sx,atoms,probs,variances)
### Output the vector of local false discovery rates ###
st$localfdr

}
\references{
Basu, P., Cai, T.T., Das, K. and Sun, W., 2018. Weighted false discovery rate control in large-scale multiple testing. Journal of the American Statistical Association, 113(523), pp.1172-1183.

Scott, J.G., Kelly, R.C., Smith, M.A., Zhou, P. and Kass, R.E., 2015. False discovery rate regression: an application to neural synchrony detection in primary visual cortex. Journal of the American Statistical Association, 110(510), pp.459-471.
}
