% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myFUN.R
\name{marg1}
\alias{marg1}
\title{Implements a profile likelihood based algorithm for estimating signal proportion and density}
\usage{
marg1(y, x, blambda = 1e-06/length(y), level = 0.05)
}
\arguments{
\item{y}{The observed vector of z-scores.}

\item{x}{The \eqn{n\times p} data matrix, where \eqn{n} must be equal to thelength of y. If you are interested in the intercept, you must add a column of \eqn{1's} to \eqn{x}.}

\item{blambda}{The tolerance threshold while implementing a quasi-Newton approach for estimating the signal proportion. Default is set to \eqn{1e-6/}length(y). We recommend not changing it unless absolutely sure.}

\item{level}{The level at which the false discovery rate is to be controlled. Should be a scalar in \eqn{[0,1]}. Default set to \eqn{0.05}.}
}
\value{
This function returns a list consisting of the following:

\item{p}{The estimated prior probabilities, i.e., \eqn{\hat\pi(\cdot)} evaluated at the data points.}

\item{b}{The estimates for the coefficient vector in the logistic function.}

\item{f1y}{The vector of estimated signal density evaluated at the data points.}

\item{kwo}{This is a list with four items - i. \emph{atoms}: The vector of means for the Gaussian distributions used to approximate \eqn{G(\cdot)}, ii. \emph{probs}: The vector of probabilities for each Gaussian component used to approximate \eqn{G(\cdot)}, iii. \emph{f1y}: Same as f1y above, iv. \emph{ll}: The average of the logarithmic values of f1y. }

\item{localfdr}{The vector of estimated local false discovery rates evaluated at the data points.}

\item{den}{The vector of estimated conditional densities evaluated at the data points.}

\item{ll}{The log-likelihood evaluated at the estimated optima.}

\item{rejset}{The vector of \eqn{1}s and \eqn{0}s where \eqn{1} indicates that the corresponding hypothesis is to be rejected.}

\item{pi0}{The average of the entries of the vector \emph{p}.}

\item{ll_list}{The vector of profile log-likelihoods corresponding to a pre-determined set of grid points for \eqn{\bar\pi}. The highest element of this vector is the output in \emph{ll}.}
}
\description{
This function estimates the signal proportion and the signal density by using
the marginal distribution of \eqn{Y}, followed by a profile likelihood based approach.
It returns the vector of estimated local false discovery rates and the corresponding
rejection set at a prespecified level for the false discovery rate.
}
\details{
Note that the marginal distribution of \eqn{Y} based on the aforementioned model
is same as that in a standard two-groups model (Efron 2008, see \strong{References}). Fixing
\eqn{\bar\pi = \mathbf{E}[\pi(X)]}, the signal density \eqn{\phi_1(\cdot)} is
estimated using the Rmosek optimization suite. The primary idea is to approximate
the mixing distribution \eqn{G(\cdot)} using \eqn{\max\{100,\sqrt{n}\}} many
components, each having a suitable Gaussian distribution. The signal proportion
is then estimated
using the BFGS algorithm. Finally, the algorithm chooses the best value of \eqn{\bar\pi} based
on a profile likelihood approach.
}
\references{
Deb, N., Saha, S., Guntuboyina, A. and Sen, B., 2018. Two-component Mixture Model in the Presence of Covariates. arXiv preprint arXiv:1810.07897.

Koenker, R. and Mizera, I., 2014. Convex optimization, shape constraints, compound decisions, and empirical Bayes rules. Journal of the American Statistical Association, 109(506), pp.674-685.

Efron, B., 2008. Microarrays, empirical Bayes and the two-groups model. Statistical science, pp.1-22.
}
