% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NostalgiR.R
\name{nos.image}
\alias{nos.image}
\title{nos.image text-based image plot.}
\usage{
nos.image(data, xmin = 1, xmax = dim(data)[1], ymin = 1,
  ymax = dim(data)[2], xlab = NULL, ylab = NULL, ratio = 0.35,
  width = round(options()$width * 0.8), height = round(ratio * width),
  pch = c(".", "o", "x", "X", "#"))
}
\arguments{
\item{data}{A numeric matrix of data to be plotted. \code{NA} and \code{NaN} are allowed, but are removed for the plot. Infinities will cause an error.}

\item{xmin}{A numeric value indicating the smallest x-axis value, which corresponds to the first row of data.}

\item{xmax}{A numeric value indicating the greatest x-axis value, which corresponds to the last row of data.}

\item{ymin}{A numeric value indicating the smallest y-axis value, which corresponds to the first column of data.}

\item{ymax}{A numeric value indicating the greatest y-axis value, which corresponds to the last column of data.}

\item{xlab}{Label of the x-axis of the plot.}

\item{ylab}{Label of the y-axis of the plot.}

\item{ratio}{Coefficient that controls the aspect ratio of the plot.}

\item{width}{Width of the plot in points.}

\item{height}{Height of the plot in points.}

\item{pch}{A vector of single-character symbols. The length of the vector determines the number of bins that the data is partitioned into. From left to right, the symbols represent an increasing order of binned.}
}
\description{
Produces a text-based image plot for the visualization of three-dimensional data that are stored in a matrix.
}
\note{
Due to rounding to a relatively crude grid results can only be approximate. The equally spaced axis ticks, for example, may be non-equally spaced in the plot. Further, due to the crude grid also there might be several points per character. The function uses the same plotting symbol no matter how many points coincide on one character position. The bins are equally spaced between the minimum and the maximum value of the data matrix, and are produced using the \code{\link[graphics]{hist}} function. The legend reports the smallest and largest value of each bin associated with each plot symbol.
}
\examples{
## Produce the image plot of the volcano dataset, using the default plotting symbols.
library(datasets)
nos.image(volcano)

## Produce the image plot of the volcano dataset, using the plotting symbols 1:9.
library(datasets)
nos.image(volcano,pch=1:9)
}
\author{
Hien D. Nguyen
}
\seealso{
\code{\link[graphics]{hist}}, \code{\link[graphics]{image}}, \code{\link[datasets]{volcano}}, and \code{\link[txtplot]{txtplot}}.
}

