% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_regfunctions.R
\name{h_OSCV_reg}
\alias{h_OSCV_reg}
\title{The OSCV bandwidth in the regression context.}
\usage{
h_OSCV_reg(desx, y, stype)
}
\arguments{
\item{desx}{numerical vecror of design points,}

\item{y}{numerical vecror of data points corresponding to the design points \eqn{desx},}

\item{stype}{smoothness of the regression function: (\eqn{stype=0}) smooth function; (\eqn{stype=1}) nonsmooth function.}
}
\value{
The OSCV bandwidth (scalar).
}
\description{
Computing the OSCV bandwidth for the Gaussian local linear regression estimator. The Gaussian kernel is used in the bandwidth selection stage. The smoothness of the regression function is to be specified by the user.
}
\details{
Computing the OSCV bandwidth for the data vector \eqn{(desx,y)}. The Gaussian kernel is used for the cross-validation purposes and in the stage of computing the resulting local linear regression estimate. No additional rescaling of the computed bandwidth is needed. The smoothness of the regression function \eqn{stype}, essentially, determines the value of the bandwidth rescaling constant that is chosen in the body of the function. Thus, the constant is equal to 0.6168471 in the smooth case, and 0.5730 in the nonsmooth case. See Savchuk, Hart and Sheather (2016). The OSCV bandwidth is the minimizer of the OSCV function \code{\link{OSCV_reg}}.
}
\examples{
\dontrun{
# Example (Old Faithful geyser)
xdat=faithful[[2]]     # waiting time
ydat=faithful[[1]]     # eruption duration
u=seq(40,100,len=1000)
h_oscv=round(h_OSCV_reg(xdat,ydat,0),digits=4)
l=loclin(u,xdat,ydat,h_oscv)
dev.new()
plot(xdat,ydat,pch=20,cex=1.5,cex.axis=1.7,cex.lab=1.7,xlab="waiting time",
ylab="eruption duration")
lines(u,l,'l',lwd=3)
title(main="Data and LLE",cex.main=1.7)
legend(35,5,legend=paste("h_OSCV=",h_oscv),cex=2,bty="n")
legend(80,3,legend="n=272",cex=2,bty="n")
}
}
\references{
\itemize{
  \item Hart, J.D. and Yi, S. (1998). One-sided cross-validation. \emph{Journal of the American Statistical Association}, 93(442), 620-631.
  \item Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2013). One-sided cross-validation for nonsmooth regression functions. \emph{Journal of Nonparametric Statistics}, 25(4), 889-904.
  \item Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2016). Corrigendum to "One-sided cross-validation for nonsmooth regression functions". \emph{Journal of Nonparametric Statistics}, 28(4), 875-877.
  \item Savchuk, O.Y., Hart, J.D. (2017). Fully robust one-sided cross-validation for regression functions. \emph{Computational Statistics}, doi:10.1007/s00180-017-0713-7.
}
}
\seealso{
\code{\link{OSCV_reg}}, \code{\link{loclin}}, \code{\link{C_smooth}}, \code{\link{h_OSCV_dens}}, \code{\link{h_ASE_reg}}.
}
