% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS.R
\docType{package}
\name{OmicsPLS}
\alias{OmicsPLS}
\title{Data integration with O2PLS: Two-Way Orthogonal Partial Least Squares}
\description{
The OmicsPLS package is an R package for penalized integration of heterogeneous omics data. 
The software articles are published in (el Bouhaddani et al, 2018, \doi{10.1186/s12859-018-2371-3}) and (Gu et al, 2020, \doi{10.1186/s12859-021-03958-3}).
OmicsPLS includes the O2PLS fit, the GO2PLS fit, cross-validation tools and some misc functions.
}
\section{Model and assumptions}{

\strong{Note that the rows of \code{X} and \code{Y} are the subjects and columns are variables.}
The number of columns may be different, but the subjects should be the same in both datasets.

The O2PLS model (Trygg & Wold, 2003) decomposes two datasets \eqn{X} and \eqn{Y} into three parts. 
\itemize{
 \item{1.} A joint part, representing the relationship between \eqn{X} and \eqn{Y}
 \item{2.} An orthogonal part, representing the unrelated latent variation in \eqn{X} and \eqn{Y} separately.
 \item{3.} A noise part capturing all residual variation.
}

See also the corresponding paper (el Bouhaddani et al, 2018).
}

\section{Fitting}{

The O2PLS fit is done with \code{\link{o2m}}. 
For data \code{X} and \code{Y} you can run \code{o2m(X,Y,n,nx,ny)} for an O2PLS fit with \code{n} joint and \code{nx, ny} orthogonal components.
See the help page of \code{\link{o2m}} for more information on parameters.
There are four ways to obtain an O2PLS fit, depending on the dimensionality.
\itemize{
 \item{} For the not-too-high dimensional case, you may use \code{\link{o2m}} with default parameters. E.g. \code{o2m(X,Y,n,nx,ny)}.
 \item{} In case you only want the parameters, you may add \code{stripped = TRUE} to obtain a stripped version of \code{o2m} which avoids calculating and storing some matrices. E.g. \code{o2m(X,Y,n,nx,ny,stripped=TRUE)}.
 \item{} For high dimensional cases, defined by \code{ncol(X)>p_thresh} and \code{ncol(Y)>q_thresh}, a NIPALS approach is used which avoids storing large matrices. E.g. \code{o2m(X,Y,n,nx,ny,p_thresh=3000,q_thresh=3000)}.
 The thresholds are by default both at 3000 variables.
 \item{} If you want a stripped version in the high dimensional case, add \code{stripped = TRUE}. E.g. \code{o2m(X,Y,n,nx,ny,stripped=TRUE,p_thresh=3000,q_thresh=3000)}.
 \item{} For GO2PLS, add \code{sparsity = TRUE} and specify how many variables or groups to retain. E.g. \code{o2m(X,Y,n,nx,ny,sparse=TRUE,keepx, keepy)}.
}
}

\section{Obtaining results}{

After fitting an O2PLS model, by running e.g. \code{fit = o2m(X,Y,n,nx,ny)}, the results can be visualised.
Use \code{\link{plot}(fit,...)} to plot the desired loadings with/without ggplot2.
Use \code{\link{summary}(fit,...)} to see the relative explained variances in the joint/orthogonal parts.
Also plotting the joint scores \code{fit$Tt, fit$U} and orthogonal scores \code{fit$T_Yosc, fit$U_Xosc} are of help.
}

\section{Cross-validating}{
 
Determining the number of components \code{n,nx,ny} is an important task. For this we have two methods.
See \code{citation("OmicsPLS")} for our proposed approach for determining the number of components, implemented in \code{crossval_o2m_adjR2}!
\itemize{
 \item{} Cross-validation (CV) is done with \code{\link{crossval_o2m}} and \code{\link{crossval_o2m_adjR2}}, both have built in parallelization which relies on the \code{parallel} package.
 Usage is something like \code{crossval_o2m(X,Y,a,ax,ay,nr_folds)} where \code{a,ax,ay} are vectors of integers. See the help pages.
 \code{nr_folds} is the number of folds, with \code{nr_folds = nrow(X)} for Leave-One-Out CV.
 \item{} For \code{crossval_o2m_adjR2} the same parameters are to be specified. This way of cross-validating is (potentially much)
 faster than the standard approach. It is also recommended over the standard CV.
 \item{} To cross-validate the number of variables to keep, use \code{\link{crossval_sparsity}}. 
}
}

\section{S3 methods}{

There are S3 methods implemented for a fit obtained with \code{o2m}, i.e. \code{fit <- o2m(X,Y,n,nx,ny)}
\itemize{
  \item{} Use plot(fit) to plot the loadings, see above.
  \item{} Use \code{\link{loadings}(fit)} to extract a matrix with loading values
  \item{} Use \code{\link{scores}(fit)} to extract the scores
  \item{} Use \code{\link{print}} and \code{\link{summary}} to print and summarize the fit object
}
}

\section{Imputation}{

When the data contains missing values, one should impute them prior to using O2PLS.
There are many sophisticated approaches available, such as MICE and MissForest, and no one approach is the best for all situations.
To still allow users to quickly impute missing values in their data matrix, 
the \code{\link{impute_matrix}} function is implemented. 
It relies on the \code{\link{softImpute}} function+package and imputes based on the singular value decomposition.
}

\section{Misc}{

Also some handy tools are available
\itemize{
 \item{} \code{\link{orth}(X)} is a function to obtain an orthogonalized version of a matrix or vector \code{X}.
 \item{} \code{\link{ssq}(X)} is a function to calculate the sum of squares (or squared Frobenius norm) of \code{X}. See also \code{\link{vnorm}} for calculating the norm of each column in \code{X}.
 \item{} \code{\link{mse}(x, y)} returns the mean squared difference between two matrices/vectors. 
}
}

\section{Citation}{

If you use the OmicsPLS R package in your research, please cite the corresponding software paper:

\strong{el Bouhaddani, S., Uh, H.-W., Jongbloed, G., Hayward, C., Klarić, L., Kiełbasa, S. M., & Houwing-Duistermaat, J.} (2018).
\emph{Integrating omics datasets with the OmicsPLS package.}
 BMC Bioinformatics, 19(1). \doi{10.1186/s12859-018-2371-3}

The bibtex entry can be obtained with command \code{citation("OmicsPLS")}.
Thank you!

The original paper proposing O2PLS is

\strong{Trygg, J., & Wold, S.} (2003). 
\emph{O2-PLS, a two-block (X-Y) latent variable regression (LVR) method with an integral OSC filter.} 
Journal of Chemometrics, 17(1), 53-64. \doi{10.1002/cem.775}
}

\author{
Said el Bouhaddani (\email{s.elbouhaddani@umcutrecht.nl}, Twitter: @selbouhaddani),
Zhujie Gu, 
Szymon Kielbasa,
Geurt Jongbloed,
Jeanine Houwing-Duistermaat,
Hae-Won Uh.

Maintainer: Said el Bouhaddani (\email{s.elbouhaddani@umcutrecht.nl}).
}
\keyword{OmicsPLS}
