% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeSetPartRegimes}
\alias{PCMTreeSetPartRegimes}
\title{Set regimes for the parts in a tree}
\usage{
PCMTreeSetPartRegimes(tree, part.regime, setPartition = FALSE, inplace = TRUE)
}
\arguments{
\item{tree}{a PCMTree object.}

\item{part.regime}{a named vector containing regimes to be assigned to
some of or to each of the parts in the tree.}

\item{setPartition}{a logical indicating if the partition of the tree should
be set as well. If this argument is set to TRUE, the names of part.regime
are passed as the nodes argument in a call to \code{PCMTreeSetPartition}.
Default: FALSE.}

\item{inplace}{a logical indicating if the change should be done to the tree
in the calling environment (TRUE) or a copy of the tree with set edge.part
member should be returned (FALSE). Default is TRUE.}
}
\value{
If inplace is TRUE nothing, otherwise a copy of the tree with set
edge.part and part.regime members.
}
\description{
Set regimes for the parts in a tree
}
\examples{
tree <- PCMTree(ape::rtree(25))
PCMTreeGetPartition(tree)
PCMTreeGetPartRegimes(tree)
PCMTreeGetPartNames(tree)

PCMTreeSetPartRegimes(tree, c(`26` = 2))
PCMTreeGetPartition(tree)
PCMTreeGetPartRegimes(tree)
PCMTreeGetPartNames(tree)

PCMTreeSetPartRegimes(tree, c(`26` = "global-regime"))
PCMTreeGetPartition(tree)
PCMTreeGetPartRegimes(tree)
PCMTreeGetPartNames(tree)

# This should fail because no partition with nodes 26, 28 and 41 has been
# done.
ggplot2::should_stop(
  PCMTreeSetPartRegimes(tree, c(`26` = "a", `28` = "b", `41` = "c")))
# This should succeed and change the partition as well as regime assignment
PCMTreeSetPartRegimes(
  tree, c(`26` = "a", `28` = "b", `41` = "c"), setPartition = TRUE)
PCMTreeGetPartition(tree)
PCMTreeGetPartRegimes(tree)
PCMTreeGetPartNames(tree)



set.seed(1, kind = "Mersenne-Twister", normal.kind = "Inversion")
# number of tips
N <- 40

# tree with one regime
tree.a <- ape::rtree(N)

tree.a <- PCMTree(tree.a)

PCMTreeSetPartRegimes(
  tree.a,
  part.regime = structure("a", names = as.character(N+1L)),
  setPartition = TRUE,
  inplace = TRUE)


\donttest{
PCMTreePlot(tree.a) + ggtree::geom_nodelab() + ggtree::geom_tiplab()
}
tree.ab <- tree.a
PCMTreeSetPartRegimes(
  tree.ab,
  part.regime = structure(c("a", "b"), names = as.character(c(N+1L, N+31L))),
  setPartition = TRUE,
  inplace = TRUE)
\donttest{
PCMTreePlot(tree.ab) + ggtree::geom_nodelab() + ggtree::geom_tiplab()
}
}
\seealso{
\code{\link{PCMTree}}
}
