% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HOMTESTGLM.R
\name{HOMTESTGLM}
\alias{HOMTESTGLM}
\title{HOMTESTGLM}
\usage{
HOMTESTGLM(X, Y, FAMILY, Nfactors, Maxit = 100, tol = 0.001)
}
\arguments{
\item{X}{The (NT) times p design matrix, without an intercept where N=number of individuals, T=length of time series, p=number of explanatory variables.}

\item{Y}{The T times N panel of response where N=number of individuals, T=length of time series.}

\item{FAMILY}{A description of the error distribution and link function to be used in the model just like in glm functions.}

\item{Nfactors}{A pre-specified number of common factors.}

\item{Maxit}{A maximum number of iterations in optimization. Default is 100.}

\item{tol}{Tolerance level of convergence. Default is 0.001.}
}
\value{
A list with the following components:
\itemize{
\item Coefficients: The estimated heterogeneous coefficients.
\item Factors: The estimated common factors across groups.
\item Loadings: The estimated factor loadings for the common factors.
\item pvalue: The p-value of the homogeneity test.
}
}
\description{
This function tests homogeneity of the regression coefficients in heterogeneous generalized linear models with interactive effects.
}
\examples{
fit <- HOMTESTGLM(data2X,data2Y,binomial(link=logit),2,10,0.5)
}
\references{
Ando, T. and Bai, J. (2015) A simple new test for slope homogeneity in panel data models with interactive effects. Economics Letters, 136, 112-117.
}
