% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLreg.R
\name{influence}
\alias{influence}
\title{Influence Diagnostics for PLreg Objects}
\usage{
influence(model, graph = TRUE, ...)
}
\arguments{
\item{model}{fitted model object of class "\code{PLreg}".}

\item{graph}{logical. If \code{graph = TRUE} the plots are shown, if
\code{graph = FALSE} the plots are not shown. Default is \code{graph = TRUE}.}

\item{...}{currently not used.}
}
\value{
\code{influence} returns a list with three objects:
\item{case.weights}{The values of \eqn{h_{max}} eigenvector based on case
weights perturbation scheme (see Queiroz and Ferrari (2021)).}
\item{totalLI}{The total local influence (see Lesaffre and Verbeke (1998))}
\item{GL}{The diagonal elements of the generalized leverage matrix.}
}
\description{
The \code{influence} function provides two influence measures and the generalized
leverage for power logit regression models.
}
\examples{
data("Firm")

fitPL <- PLreg(firmcost ~ sizelog + indcost | sizelog + indcost,
              data = Firm, family = "SLASH", zeta = 2.13)
\donttest{
influence_measures = influence(fitPL, graph = FALSE)
plot(influence_measures$case.weights, type = "h", ylim = c(0,1))
plot(influence_measures$totalLI, type = "h", ylim = c(0,6))
plot(Firm$sizelog, influence_measures$GL, pch = "+")}

}
\references{
Queiroz, F. F. and Ferrari, S. L. P. (2022). Power logit regression
for modeling bounded data. \emph{arXiv}:2202.01697.
}
\seealso{
\code{\link{PLreg}}, \code{\link{residuals.PLreg}}, \code{\link{envelope}},
\code{\link{plot.PLreg}}
}
