% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Grubbs.R
\name{Grubbs}
\alias{Grubbs}
\alias{qgrubbs}
\alias{pgrubbs}
\title{Grubbs distribution}
\usage{
qgrubbs(p, n)

pgrubbs(q, n, lower.tail = TRUE)
}
\arguments{
\item{p}{vector of probabilities.}

\item{n}{total sample size.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x] otherwise, P[X > x].}
}
\value{
\code{pgrubbs} gives the distribution function and
\code{qgrubbs} gives the quantile function.
}
\description{
Distribution function and quantile function
    for Grubbs distribution.
}
\examples{
qgrubbs(0.05, 7)
}
\references{
Grubbs, F. E. (1950) Sample criteria for testing outlying observations.
\emph{Ann. Math. Stat.} \bold{21}, 27--58.

Wilrich, P.-T. (2011) Critical values of Mandel's h and k,
Grubbs and the Cochran test statistic. \emph{Adv. Stat. Anal.}.
\doi{10.1007/s10182-011-0185-y}.
}
\seealso{
\code{\link{TDist}}
}
\keyword{distribution}
