% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.pumpresult}
\alias{plot.pumpresult}
\title{Plot a single scenario pump object (result function)}
\usage{
\method{plot}{pumpresult}(x, ...)
}
\arguments{
\item{x}{pumpresult object.}

\item{...}{additional parameters.}
}
\value{
plot; a ggplot object of power across
differen definitions.
}
\description{
Works on an object returned by pump_power(),
and visualizes different definitions of power across
MTPs. This function does not apply to pump_mdes()
or pump_sample() objects, as these functions only
return a single value.
}
\examples{
pp1 <- pump_power(d_m = "d2.2_m2rc", MTP = 'HO',
 nbar = 50, J = 20, M = 8, numZero = 5,
 MDES = 0.30, Tbar = 0.5, alpha = 0.05, two.tailed = FALSE,
 numCovar.1 = 1, numCovar.2 = 1, R2.1 = 0.1, R2.2 = 0.7, 
 ICC.2 = 0.05, rho = 0.2, tnum = 5000)
 
plot(pp1)
}
