% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParallelIniting.R
\name{ParallelComputing}
\alias{ParallelComputing}
\title{ParallelComputing Functions}
\usage{
ParallelComputing(outpath,mymodels)
}
\arguments{
\item{outpath}{: Output path of the result of the prediction file. The default is "output".}

\item{mymodels}{: The models were selected, including QRF,RF and MLR.}
}
\details{
This function is the main function that performs parallel computations
The outpath field refers to the filename of the data output
The mymodels field has three modes to choose from: QRF,RF and MLR
‘QRF’ stands for Quantile Regression Forest Model Prediction Method
‘RF’ stands for Random Forest Model Prediction Method
‘MLR’ stands for Multiple Linear Regression Prediction Model
}
\description{
ParallelComputing computings
}
\examples{
\donttest{
## This function performs parallel computing, of which the parameters are as follows:
## outpath: the filename of the data output
## mymodels: which model user want to use. Three modes are available:
## Quantile Regression Forest (QRF),Random Forest (RF) and Multiple Linear Regression (MLR)

####################################################################################
# Example 1: Using random forest to produce soil map based on data in this package
# Loads related data sets
data("df.input" , package = "ParallelDSM")
data("df.mrrtf" , package = "ParallelDSM")
data("df.dem" , package = "ParallelDSM")

# Sets the path to the folder where the dataset will be stored
sampledata <- system.file("extdata" , "covariate", package = "ParallelDSM")

# Initializing the parameters for parallel computing
# ParallelInit_Test is same as ParallelInit
ParallelInit_Test(sampledata,df.input,dsmformul="socd030 ~ dem + mrrtf")
NormalizeData()
ParallelComputing(outpath = "mlrOutput" , mymodels = "MLR")
###################################################################################

###################################################################################
##  Example 2: Performing soil mapping based on my data with 3 CPUs ##

myinput <- "./all.input.csv"
# The sample data represents the file name where the data file is stored

# ‘covariate’ is the path name of a file
sampledata <- "./covariate" # the directory and filename
# The third parameter represents the name of the TIF file.
# nblock is used to partition the tif data into several blocks in the terms of row
# An appropriate nblock may optimize the speedup of parallel computing
ParallelInit(myinput,sampledata,"socd030 ~ twi + dem", nblock = 30 , ncore = 3)

ParallelComputing(outpath = "qrfOutput" , mymodels = "QRF")
###################################################################################

}
}
\references{
Breiman, L. (2001). Random forests. Mach. Learn. 45, 5–32.
Meinshausen, N. (2006) "Quantile Regression Forests", Journal of Machine Learning Research 7,
983-999 http://jmlr.csail.mit.edu/papers/v7/
}
