% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partiallyoverlapping.R
\name{Prop.test}
\alias{Prop.test}
\title{The partially overlapping samples z-test for dichotomous variables}
\usage{
Prop.test(x1 = NULL, x2 = NULL, x3 = NULL, x4 = NULL,
  alternative = "two.sided", conf.level = NULL, stacked = FALSE)
}
\arguments{
\item{x1}{a vector of unpaired observations in Sample 1 (or all observations in Sample 1 if stacked = "TRUE")}

\item{x2}{a vector of unpaired observations in Sample 2 (or all observations in Sample 2 if stacked = "TRUE")}

\item{x3}{a vector of paired observations in Sample 1 (not applicable if stacked = "TRUE")}

\item{x4}{a vector of paired observations in Sample 2 (not applicable if stacked = "TRUE")}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the interval.}

\item{stacked}{indicator of whether paired and unpaired observations are stacked within one vector ("TRUE"), or if specified as four separate vectors (default)}
}
\value{
A list which contains the following components of the test:

statistic  ~~ The value of the z-statistic

p.value  ~~ The p-value for the test

estimate ~~ The estimated difference in proportions

conf.int ~~ A confidence interval for the difference in proportions appropriate to the specified alternative hypothesis
}
\description{
Performs a comparison of proportions using the partially overlapping z-test, for two dichotomous samples each with paired and unpaired observations.
This functions calculates the test statistic, and the p-value. Additionally calculates a confidence interval for the difference in means when requested.
}
\details{
By default, four vectors are to be specified: unpaired observations in Sample 1, unpaired observations in Sample 2, paired observations in Sample 1, paired observations in Sample 2.
If the structure of your data is of two vectors, one for each sample, then the option stacked = TRUE can be specified.

The formula is only applicable for the 2 sample partially overlapping samples t-test. The number of unpaired observations may be zero for up to one of the two samples. The number of paired observations must be of equal length of two or greater. Error messages are generated when these conditions are not true
Assumes the raw count data is in a data frame of "1"s and "0"s. Missing observations are recorded as "NA", for unpaired observations the corresponding observation for the "missing" pair is recorded as "NA".
Corresponding pairs should be given on the same row when this option is applied.
}
\examples{

# Example taken from Derrick, Dobson-Mckittrick, Toher and White, (2015)
# Test statistics for comparing two proportions with partially overlapping
# samples. Journal of Applied Quantitative Methods, 10(3) 
 
#The proportions for two groups, "a" and "b" are compared 
#where the raw data "1", or "0" for each unit is recorded in a data frame.
#The 15 paired observations in this example are given first,
#followed by 9 independent observations in Sample 1, 
#followed by 6 independent observations in Sample 2
#Independent observations and the paired samples stacked for each sample:
a<-c(1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,NA,NA,NA,NA,NA,NA)
b<-c(1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,NA,NA,NA,NA,NA,NA,NA,NA,NA,1,1,1,1,1,1)
Prop.test(a,b,stacked=TRUE,conf.level=.95) #Perfroms the robust 'z8' test.
#p.value = 0.053
}
