% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.perseus.default}
\alias{read.perseus.default}
\alias{read.perseus.as.list}
\alias{read.perseus.as.matrixData}
\alias{read.perseus.as.ExpressionSet}
\alias{read.perseus}
\title{Read Perseus matrix files}
\usage{
read.perseus.default(con, check = TRUE, additionalMatrices = FALSE)

read.perseus.as.list(con, check = TRUE)

read.perseus.as.matrixData(con, check = TRUE,
  additionalMatrices = FALSE)

read.perseus.as.ExpressionSet(con, check = TRUE)

read.perseus(con, check = TRUE, additionalMatrices = FALSE)
}
\arguments{
\item{con}{A \code{\link{connection}} object or the path to input file}

\item{check}{Logical indicating whether to check for the validity of the exported object (slightly slower)}

\item{additionalMatrices}{Logical indication whether to write out quality and imputation matrices in perseus format}
}
\value{
Defaults to a \code{\link{matrixData}} object.
}
\description{
Read the custom Perseus matrix file format *.txt into R.
}
\section{Functions}{
\itemize{
\item \code{read.perseus.default}: Returns a list used internally to generate all other outputs

\item \code{read.perseus.as.list}: Returns explicitly as a list

\item \code{read.perseus.as.matrixData}: Returns explicitly as a specialized matrix data object

\item \code{read.perseus.as.ExpressionSet}: Returns a bioconductor expression set object
}}

\note{
Limitations to column names in R still apply. Column names valid
in Perseus, such as 'Column 1' will be changed to 'Column.1'

If the provided connection \code{con} is a character string, it will assumed
to be a file path. A \code{\link{connection}} which is not seekable (see \code{\link{isSeekable}})
will be written to a temporary file. Any connection will be closed when \code{read.perseus} exits.
\code{read.perseus.as.list}, \code{read.perseus.as.matrixData} and \code{read.perseus.as.ExpressionSet} are also available depending on the class desired as an output
}
\examples{
tmp <- tempfile(fileext = ".txt")
write('Column_1\\tColumn_2\\tColumn_3
#!{Description}\\t\\t
#!{Type}E\\tE\\tE
-1.860574\\t-0.3910594\\t0.2870352
NaN\\t-0.4742951\\t0.849998', file=tmp)
mdata <- read.perseus(tmp)

}
\seealso{
\code{\link{write.perseus}}

\code{\link{matrixData}}
}
