% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variancecomponentFunctions.R
\name{correlatedBgEffects}
\alias{correlatedBgEffects}
\title{Simulate correlated background effects.}
\usage{
correlatedBgEffects(
  N,
  P,
  pcorr = NULL,
  corr_mat = NULL,
  sampleID = "ID_",
  phenoID = "Trait_",
  id_samples = NULL,
  id_phenos = NULL,
  verbose = FALSE
)
}
\arguments{
\item{N}{Number [integer] of samples to simulate.}

\item{P}{Number [integer] of phenotypes to simulate.}

\item{pcorr}{Initial strength of correlation [double] between neighbouring 
traits. Decreases by pcorr^(distance); distance from 0 to P-1. See details.}

\item{corr_mat}{[P x P] correlation matrix [double] as covariance 
component for the multivariate normal distribution. If not provided, pcorr is
used to construct the correlation matrix.}

\item{sampleID}{Prefix [string] for naming samples.}

\item{phenoID}{Prefix [string] for naming traits.}

\item{id_samples}{Vector of [NrSamples] sample IDs [string]; if not provided
constructed by paste(sampleID, 1:N, sep="").}

\item{id_phenos}{Vector of [NrTraits] phenotype IDs [string]; if not provided
constructed by paste(phenoID, 1:P, sep="").}

\item{verbose}{[boolean] If TRUE, progress info is printed to standard out.}
}
\value{
Named list with [N x P] matrix of correlated background effects (
correlatedBg) and the correlation matrix (cov_correlated). If corr_mat 
provided corr_mat == cov_correlated.
}
\description{
correlatedBgEffects computes a background effect that simulates structured 
correlation between the phenotypes.
}
\details{
correlatedBgEffects can be used to simulate phenotypes with a 
defined level of correlation between traits. If the corr_mat is not provided,
a simple correlation structure based on the distance of the traits will be 
constructed. Traits of distance d=1 (adjacent columns) will have correlation 
cor=\eqn{pcorr^1}{pcorr^1}, traits with d=2 have cor=\eqn{pcorr^2}{pcorr^2} 
up to traits with d=(P-1) cor=\eqn{pcorr^{(P-1)}}{pcorr^{(P-1)}} and 
0 < pcorr < 1. The correlated background effect correlated is simulated based 
on this correlation structure C: 
\eqn{correlated ~ N_{NP}(0,C)}{correlated ~ N_{NP}(0,C)}.
}
\examples{
correlatedBg <- correlatedBgEffects(N=100, P=20, pcorr=0.4)
}
\seealso{
\code{\link[mvtnorm]{rmvnorm}} which is used to simulate the 
multivariate normal distribution
}
