% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genotypeFunctions.R
\name{simulateGenotypes}
\alias{simulateGenotypes}
\title{Simulate bi-allelic genotypes.}
\usage{
simulateGenotypes(
  N,
  NrSNP = 5000,
  frequencies = c(0.1, 0.2, 0.4),
  sampleID = "ID_",
  snpID = "SNP_",
  verbose = TRUE
)
}
\arguments{
\item{N}{Number of samples for which to simulate bi-allelic genotypes.}

\item{NrSNP}{Number of SNPs to simulate.}

\item{frequencies}{Vector of allele frequencies [double] from which to
sample.}

\item{sampleID}{Prefix [string] for naming samples (will be followed by
sample number from 1 to N when constructing id_samples).}

\item{snpID}{Prefix [string] for naming SNPs (will be followed by SNP number
from 1 to NrSNP when constructing id_snps).}

\item{verbose}{[boolean] If TRUE, progress info is printed to standard out.}
}
\value{
Named list with [N x NrSNP] matrix of simulated genotypes
(genotypes), their SNP frequencies (freq), a vector of sample IDs
(id_samples) and a vector of SNP IDs (id_snps).
}
\description{
Simulate bi-allelic genotypes.
}
\examples{
N10NrSNP10 <- simulateGenotypes(N=10, NrSNP=10)
N10NrSNP10 <- simulateGenotypes(N=10, NrSNP=10,
frequencies=c(0.2,0.3,0.4))
}
\seealso{
\code{\link{standardiseGenotypes}}
}
