% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nicfi_utils.R
\name{nicfi_quads_bbox}
\alias{nicfi_quads_bbox}
\title{Computes the NICFI Quads based on a mosaic-id and a specified Area of Interest (bounding box or Well Known Text)}
\usage{
nicfi_quads_bbox(
  planet_api_key,
  mosaic_id,
  bbox_AOI = NULL,
  wkt_AOI = NULL,
  page_size = 50,
  crs_bbox = 4326,
  verbose = FALSE
)
}
\arguments{
\item{planet_api_key}{a character string specifying the Planet API key (see the references on how to acquire this key)}

\item{mosaic_id}{a character string specifying the 'Mosaic' id as returned from the 'nicfi_mosaics()' function}

\item{bbox_AOI}{either NULL or a list of the format "list(xmin = xmin, xmax = xmax, ymin = ymin, ymax = ymax)" that includes the bounding box 'xmin', 'xmax', 'ymin', 'ymax' coordinate values of the Area of Interest (AOI) based on which the intersected NICFI Quads have to be computed}

\item{wkt_AOI}{either NULL or a character string specifying the Well Known Text (WKT)  of the Area of Interest (AOI) based on which the intersected NICFI Quads have to be computed}

\item{page_size}{an integer value specifying the number of Quads to return (that intersect with the input bounding box or Well known text)}

\item{crs_bbox}{an integer specifying the Coordinates Reference System for the bounding box computation only.}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
an object of class list
}
\description{
Computes the NICFI Quads based on a mosaic-id and a specified Area of Interest (bounding box or Well Known Text)
}
\examples{

\dontrun{

require(PlanetNICFI)

#....................................
# first extract the available Mosaics
#....................................

api_key = 'use_your_planet_nicfi_API_key'

mosaic_files = nicfi_mosaics(planet_api_key = api_key,
                             type = 'monthly',
                             crs_bbox = 4326,
                             URL = 'https://api.planet.com/basemaps/v1/mosaics',
                             verbose = TRUE)

#....................................
# keep the mosaic of 'September 2020'
#....................................

keep_idx = 1
mosaic_ID = mosaic_files$dtbl_mosaic$id[keep_idx]


#.....................................................
# then extract the available Quad files for the Mosaic
#.....................................................

wkt_file = system.file('data_files/Sugar_Cane_Bolivia.wkt', package = "PlanetNICFI")
WKT = readLines(wkt_file, warn = FALSE)

quad_files = nicfi_quads_bbox(planet_api_key = api_key,
                              mosaic_id = mosaic_ID,
                              bbox_AOI = NULL,
                              wkt_AOI = WKT,
                              page_size = 10,
                              crs_bbox = 4326,
                              verbose = TRUE)
}
}
\references{
https://developers.planet.com/docs/basemaps/reference/#tag/Basemaps-and-Mosaics
}
