% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_GEX_expansion.R
\name{VDJ_GEX_expansion}
\alias{VDJ_GEX_expansion}
\title{Platypus V2 utility}
\usage{
VDJ_GEX_expansion(
  GEX.list,
  VDJ.GEX.integrate.list,
  highlight.isotype,
  highlight.number
)
}
\arguments{
\item{GEX.list}{The output of the automate_GEX function.}

\item{VDJ.GEX.integrate.list}{Output from VDJ_GEX_integrate function. This object needs to have the GEX and VDJ information combined and integrated. This should be on the CLONAL level from the VDJ_GEX_integrate function.}

\item{highlight.isotype}{(Optional) isotype to plot, choose between ["None","A","E","M","G","G1","G2A","G2B","G2C","G3"]. Default is None.}

\item{highlight.number}{A vector corresponding to the rank of the clones that should be specified. Default is set to "20", which will present the cluster distribution for the top 20 clones.}
}
\value{
ggplot2 plot that breaks down clonotype membership per cluster for the specified input clones.
}
\description{
only Platypus v2 Integrates VDJ and gene expression libraries by providing cluster membership seq_per_vdj object. Output will plot which transcriptional cluster (GEX) that the cells of a given clonotype are found in.
}
\examples{
\dontrun{
vdj.gex.expansion <- VDJ_GEX_expansion(GEX.list=GEX.list.output[[1]]
,VDJ.GEX.integrate.list=vdj.gex.integrate.output
,highlight.isotype = "None",highlight.number=1:20)
}
}
