% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbitSpatial.R
\docType{package}
\name{ProbitSpatial-package}
\alias{ProbitSpatial}
\alias{ProbitSpatial-package}
\title{Probit with Spatial Dependence, SAR, SEM, and SARAR Models.}
\description{
\code{ProbitSpatial} package allows to fit spatial autoregressive (SAR) and 
spatial error (SEM) probit models. It also provides functions to simulated 
spatial binary data, an empirical data set and different methods for the 
diagnostic of the estimated model.
}
\details{
The main function of this package is \code{ProbitSpatialFit}. It allows to 
fit both SAR and SEM models for big datasets in a reasonable time. The 
function is based on the maximisation of the approximate likelihood 
function. The approximation is inspired by the Mendell and Elston algorithm 
for computing multivariate normal probabilities and take advantage of the 
sparsity of the spatial weight matrix. Two methods are available for the 
estimation of the model parameter: the first one is known as conditional 
method (see Case (1992)) and performs relatively well in terms of accuracy 
of the estimated parameters and is very rapid. The second method, that 
minimises the full-log-likelihood, is slower but it should be more accurate. 
Monte Carlo experiments on simulated data reported in Martinetti and Geniaux 
(2017) showed that the full-log-likelihood approach is not always 
overperforming the conditional method in terms of accuracy. At the present 
stage, our suggestion is to use the conditional method for a first 
estimation and only attempt the full-likelihood approach in a second moment, 
when the dataset size is not bigger than a few thousands. 

Another feature of the \code{ProbitSpatialFit} function is the possibility 
to fit the model using the precision matrix instead of the 
variance-covariance matrix, since it is usually sparser and hence allows 
faster computations (see LeSage and Pace (2009)).

The output of \code{ProbitSpatialFit} function is an object of class 
\code{ProbitSpatial}, for which the methods  
\code{residuals}, \code{fitted}, \code{effects}, \code{predict} and 
\code{coef} are available.

The package also contains the function \code{sim_binomial_probit} that 
allows to simulate data samples of both SAR and SEM models. It can be used 
to replicate the Monte Carlo experiments reported in Martinetti and Geniaux 
(2017) as well as the experiment of Calabrese and Elkink (2014). 
An empirical data set \code{\link{Katrina}} on the reopening decisions of 
firms in the aftermath of the Katrina Hurricane in New Orleans is also 
available (LeSage et al.(2011)).
 
 Other packages in CRAN repository on the same subject are 
\code{McSpatial} (McMillen (2013)) and 
\code{spatialprobit} (Wilhelm and Godinho de Matos 
(2013)).

The core functions of the present package have been coded using the 
\code{Rcpp} and \code{RcppEigen} libraries (Bates and Eddelbuettel (2013)), 
that allow direct interchange of rich R objects between R and C++.
}
\references{
\describe{
\item{Bates and Eddelbuettel (2013)}{D. Bates and D. Eddelbuettel. Fast and 
elegant numerical linear algebra using the RcppEigen package. \emph{Journal 
of Statistical Software} 52, 1--24, 2013.}
\item{Case (1992)}{A. C. Case. Neighborhood Influence and Technological 
Change. \emph{Regional Science and Urban Economics} 22, 491--508, 1992.}
\item{Calabrese and Elkink (2014)}{R. Calabrese and J.A. Elkink. Estimators 
of binary spatial autoregressive models: a Monte Carlo study. \emph{Journal 
of Regional Science} 54, 664--687, 2014.}
\item{LeSage and Pace (2009)}{J. LeSage and R.K. Pace. \emph{Introduction to 
Spatial Econometrics}, CRC Press, chapter 10.1.6, 2009.}
\item{LeSage et al. (2011)}{P. LeSage, R. K. Pace, N. Lam, R. Campanella and 
X. Liu. New Orleans business recovery in the aftermath of Hurricane 
Katrina. \emph{Journal of the Royal Statistical Society A} 174, 1007--1027, 
2011.}
\item{Martinetti and Geniaux (2017)}{D. Martinetti and G. Geniaux. 
	Approximate likelihood estimation of spatial probit models. \emph{Regional 
	Science and Urban Economics} 64, 30-45, 2017.}
\item{McMillen (2013)}{D. McMillen. McSpatial: Nonparametric spatial data 
analysis. R package version 2.0, 2013.}
\item{Mendell and Elston (1974)}{N. Mendell and R. Elston. Multifactorial 
	qualitative traits: genetic analysis and prediction of recurrence risks. 
 \emph{Biometrics} 30, 41--57, 1974.}
\item{Wilhelm and Godinho de Matos (2013)}{S. Wilhelm and M. Godinho de 
Matos. Estimating Spatial Probit Models in R. \emph{The R Journal} 5, 
130--143, 2013.}
}
}
\author{
Davide Martinetti \email{davide.martinetti@inra.fr} and 
	Ghislain Geniaux  \email{ghislain.geniaux@inra.fr}
}
