% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Binary.R
\name{BinaryMC}
\alias{BinaryMC}
\title{Binary option valuation via Monte-Carlo (via) simulation.}
\usage{
BinaryMC(o = OptPx(Opt(Style = "Binary")), Q = 25,
  Type = c("cash-or-nothing", "asset-or-nothing"), NPaths = 5)
}
\arguments{
\item{o}{An \code{OptPx} object}

\item{Q}{A fixed numeric amount of payoff}

\item{Type}{Binary option type: \code{'cash-or-nothing'} or \code{'asset-or-nothing'}.}

\item{NPaths}{The number of simulation paths to use in calculating the price
Partial names are allowed, eg. \code{'c'} or \code{'a'}}
}
\value{
The original input object \code{o} with added parameters and option price \code{PxMC}
}
\description{
Binary option valuation via Monte-Carlo (via) simulation.
}
\details{
Two types of binary options are priced: \code{'cash-or-nothing'} and \code{'asset-or-nothing'}.
}
\examples{
(o = BinaryMC())$PxMC

o = OptPx(Opt(Style="Binary"))
(o = BinaryMC(o, Type="cash"))$PxMC

o = OptPx(Opt(Style="Binary"),q=0.01)
(o = BinaryMC(o, Type="asset"))$PxMC

o = OptPx(Opt(Style="Binary", S0=100, K=80),q=0.01)
(o = BinaryMC(o, Type="cash"))$PxMC

o = OptPx(Opt(Style="Binary", Right="Put", S0=50, K=60),q=0.04)
(o = BinaryMC(o, Type="asset"))$PxMC
}
\author{
Tongyue Luo, Rice University, Spring 2015.
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
pp.606-607.
}

