% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Binary.R
\name{Binary_BOPM}
\alias{Binary_BOPM}
\title{Binary option valuation vialattice tree (LT) implementation}
\usage{
Binary_BOPM(o = OptPx(Opt(Style = "Binary")), Type = c("cash-or-nothing",
  "asset-or-nothing"), Q = 1000, IncBT = FALSE)
}
\arguments{
\item{o}{\code{OptPx} object}

\item{Type}{Binary option type: \code{'cash-or-nothing'} or \code{'asset-or-nothing'}}

\item{Q}{A fixed amount of payoff}

\item{IncBT}{TRUE/FALSE, indicates whether to include the full binomial tree in the returned object}
}
\value{
original \code{OptPx} object with \code{Px.BOPM} property and (optional) binomial tree
        IncBT = FALSE: option price value (type double, class numeric)
        IncBT = TRUE: binomial tree as a list (of length (o$n+1) of numeric matrices (2 x i).
        Each matrix is a set of possible i outcomes at time step i
        columns: (underlying prices, option prices)
}
\description{
Compute option price via binomial option pricing model (recombining symmetric binomial tree)
}
\examples{
(o = Binary_BOPM())$PxBT

o = OptPx(o=Opt(Style='Binary'))
(o = Binary_BOPM(o, Type='cash', Q=100, IncBT=TRUE))$PxBT

o = OptPx(Opt(Style='Binary'), r=0.05, q=0.02, rf=0.0, vol=0.30, NSteps=5)
(o = Binary_BOPM(o, Type='cash', Q=1000, IncBT=FALSE))$PxBT

o = OptPx(o=Opt(Style='Binary'), r=0.15, q=0.01, rf=0.05, vol=0.35, NSteps=5)
(o = Binary_BOPM(o,Type='asset',Q=150, IncBT=FALSE))$PxBT

o = OptPx(o=Opt(Style='Binary'), r=0.025, q=0.001, rf=0.0, vol=0.10, NSteps=5)
(o = Binary_BOPM(o, Type='cash', Q=20, IncBT=FALSE))$PxBT
}

