% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Gap.R
\name{GapLT}
\alias{GapLT}
\title{Gap option valuation via lattice tree (LT) model}
\usage{
GapLT(o = OptPx(Opt(Style = "Gap")), K2 = 60, on = c(100, 200))
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{K2}{A numeric strike price above used in calculating if option is in the money or not, known as trigger.}

\item{on}{A vector of number of steps to be used in binomial tree averaging, vector of positive intergers.}
}
\value{
An onject of class \code{OptPx} including price
}
\description{
A binomial tree pricer of Gap options that takes the average results for given step sizes in NSteps.
Large step sizes should be used for optimal accuracy but may take a minute or so.
}
\examples{
(o = GapLT())$PxLT

o = Opt(Style="Gap",Right='Put',S0 = 500000, ttm = 1,K = 400000)
o = OptPx(o,r = .05, q=0, vol =.2)
(o = GapLT(o,K2 = 350000,on=c(498,499,500,501,502)))$PxLT

o = Opt(Style="Gap", Right='Call',S0 = 65, ttm = 1,K = 70)
o = OptPx(o,r = .05, q=.02,vol =.1)
}
\author{
Max Lee, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8. \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
\cr Humphreys, Natalia. University of Dallas.
}

