% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Perpetual.R
\name{PerpetualBS}
\alias{PerpetualBS}
\title{Perpetual option valuation via Black-Scholes (BS) model}
\usage{
PerpetualBS(o = OptPx(Opt(Style = "Perpetual"), q = 0.1))
}
\arguments{
\item{o}{AN object of class \code{OptPx}}
}
\value{
A list of class \code{Perpetual.BS} consisting of the input object \code{OptPx}
}
\description{
An exotic option is an option which has features making it more complex than commonly traded options.
             A perpetual option is non-standard financial option with no fixed maturity and no exercise limit.
             While the life of a standard option can vary from a few days to several years,
             a perpetual option (XPO) can be exercised at any time.
             Perpetual options are considered an American option. European options can be exercised only on the option's maturity date.
}
\examples{
#Perpetual American Call and Put
#Verify pricing with \\url{http://www.coggit.com/freetools}
(o <- PerpetualBS())$PxBS # Approximately valued at $8.54

#This example should produce approximately $33.66
o = Opt(Style="Perpetual", Right='Put', S0=50, K=55)
o = OptPx(o, r = .03, q = 0.1, vol = .4)
(o = PerpetualBS(o))$PxBS

#This example should produce approximately $10.87
o = Opt(Style="Perpetual", Right='Call', S0=50, K=55)
o = OptPx(o, r = .03, q = 0.1, vol = .4)
(o <- PerpetualBS(o))$PxBS
}
\author{
Kim Raath, Department of Statistics, Rice University, Spring 2015.
}
\references{
Chi-Guhn Lee, \emph{The Black-Scholes Formula}, Courses, Notes, Note2, Sec 1.5 and 1.6
             \url{http://www.mie.utoronto.ca/courses/mie566f/materials/note2.pdf}
}

