% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VarianceSwap.R
\name{VarianceSwapMC}
\alias{VarianceSwapMC}
\title{VarianceSwap option valuation via Monte Carlo (MC) simulation.}
\usage{
VarianceSwapMC(o = OptPx(o = Opt(Style = "VarianceSwap")), var = 0.2,
  NPaths = 5)
}
\arguments{
\item{o}{The \code{OptPx} Variance Swap option to price.}

\item{var}{The variance strike level}

\item{NPaths}{The number of simulation paths to use in calculating the price,}
}
\value{
The option \code{o} with the price in the field \code{PxMC} based on MC simulations and the Variance Swap option
        properties set by the users themselves
}
\description{
Calculates the price of a VarianceSwap Option using 500 Monte Carlo simulations.
\cr Important Assumptions:
The option o followes a General Brownian Motion
\eqn{ds = mu * S * dt + sqrt(vol) * S * dW} where \eqn{dW ~ N(0,1)}.
The value of \eqn{mu} (the expected price increase) is assumed to be \code{o$r-o$q}.
}
\examples{
(o = VarianceSwapMC())$PxMC #Price = ~0.0245

 (o = VarianceSwapMC(NPaths = 5))$PxMC # Price = ~0.0245

 (o = VarianceSwapMC(var=0.4))$PxMC # Price = ~-0.1565
}
\author{
Huang Jiayao, Risk Management and Business Intelligence at Hong Kong University of Science and Technology,
         Exchange student at Rice University, Spring 2015
}
\references{
Hull, J.C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod}.
\cr \url{http://stackoverflow.com/questions/25946852/r-monte-carlo-simulation-price-path-converging-volatility-issue}
}

