% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.ci.R
\name{pred.ci}
\alias{pred.ci}
\title{Calculate Cumulative Incidence}
\usage{
pred.ci(cum, tm1, failcode)
}
\arguments{
\item{cum}{a object from function \code{\link[cmprsk]{cuminc}}}

\item{tm1}{expected failure time}

\item{failcode}{value indicating the event of interest}
}
\value{
a data frame with 3 columns.  \item{column 3: }{Group name.}
  \item{column 2: }{Cumulative Incidence Probability.} \item{column 3:
  }{Variance}
}
\description{
Calculate Cumulative Incidence
}
\details{
Extract cumulative incidence and its variance from a object generated from
function \code{\link[cmprsk]{cuminc}}.
}
\examples{

 data(prostate.dat) # get demo data set
 cum <- cuminc(prostate.dat$TIME_EVENT,prostate.dat$EVENT_DOD,
               cencode = 0)
 # calculate the expected cumulative incidence by 5 year for death from
 # prostate cancer
 # Here, code for cause A is 'DOA'.
 pred.ci(cum,60,failcode = 1)

}
\seealso{
\code{\link[cmprsk]{cuminc}}
}
\author{
Michael W. Kattan, Ph.D. and Changhong Yu.\cr Department of
  Quantitative Health Sciences, Cleveland Clinic
}
\keyword{datagen}
\keyword{survival}
