% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WangF.R
\name{WangS}
\alias{WangS}
\title{The second step of wang method}
\usage{
WangS(
  flag = NULL,
  CriLOD = NULL,
  NUM = NULL,
  pheRaw = NULL,
  chrRaw_name = NULL,
  yygg = NULL,
  mx = NULL,
  phe = NULL,
  chr_name = NULL,
  gen = NULL,
  mapname = NULL,
  CLO = NULL
)
}
\arguments{
\item{flag}{fix or random model.}

\item{CriLOD}{Critical LOD scores for significant QTL.}

\item{NUM}{The number of trait.}

\item{pheRaw}{Raw phenotype matrix.}

\item{chrRaw_name}{raw chromosome name.}

\item{yygg}{covariate matrix.}

\item{mx}{raw genotype matrix.}

\item{phe}{phenotype matrix.}

\item{chr_name}{chromosome name.}

\item{gen}{genotype matrix.}

\item{mapname}{linkage map matrix.}

\item{CLO}{Number of CPUs.}
}
\value{
a list
}
\description{
The second step of wang method
}
\examples{
data(DHdata)
readraw<-Readdata(file=DHdata,fileFormat="GCIM",
method="GCIM",filecov=NULL,MCIMmap=NULL,MultiEnv=FALSE)
DoResult<-Dodata(fileFormat="GCIM",Population="DH",
method="GCIM",Model="Random",readraw,MultiEnv=FALSE)
W1re<-WangF(pheRaw=DoResult$pheRaw,genRaw=DoResult$genRaw,
mapRaw1=DoResult$mapRaw1,yygg1=DoResult$yygg1,
flagRIL=DoResult$flagRIL,cov_en=DoResult$cov_en,
Population="DH",WalkSpeed=1,CriLOD=2.5)
ws<-WangS(flag=DoResult$flag,CriLOD=2.5,NUM=1,
pheRaw=DoResult$pheRaw,chrRaw_name=W1re$chrRaw_name,
yygg=W1re$yygg,mx=W1re$mx,phe=W1re$phe,
chr_name=W1re$chr_name,gen=W1re$gen,
mapname=W1re$mapname,CLO=1)
}
