% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Quandldatatable.R
\name{Quandl.datatable.bulk_download_url}
\alias{Quandl.datatable.bulk_download_url}
\title{Generates and returns a bulk download url}
\usage{
Quandl.datatable.bulk_download_url(datatable_code, ...)
}
\arguments{
\item{datatable_code}{Datatable code on Quandl specified as a string.}

\item{...}{Additional named values that are interpreted as Quandl API parameters. Please see \url{https://docs.quandl.com/docs/parameters-1} for a full list of parameters.}
}
\value{
Returns the download url.
}
\description{
Generates and returns a bulk download url
}
\details{
Set your \code{api_key} with \code{Quandl.api_key} function. For instructions on finding your api key go to \url{https://www.quandl.com/account/profile}
}
\examples{
\dontrun{
url = Quandl.datatable.bulk_download_url("ZACKS/EE", ticker="AAPL")
}
}
\seealso{
\code{\link{Quandl.api_key}}
}
