% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Postprocessing.R
\name{plotMap}
\alias{plotMap}
\title{Plotting of maps}
\usage{
plotMap(
  envFile,
  x,
  y,
  locationProj,
  popStrCol,
  gdsFile,
  markerName,
  mapType,
  varEnvName,
  SAMethod = NULL,
  SAThreshold = NULL,
  saveType = NULL,
  rasterName = NULL,
  simultaneous = FALSE
)
}
\arguments{
\item{envFile}{char The file containing the input environmental variable of sambada.}

\item{x}{char The name of the column corresponding to the x-coordinate in the \code{envFile}. Can be set to null if unknown, in this case the maps will not be available}

\item{y}{char The name of the column corresponding to the y-coordinate in the env file. Can be set to null if x is null.}

\item{locationProj}{integer EPSG code of the geographical projection in the \code{envFile}}

\item{popStrCol}{char The name or vector of name of column(s) in \code{envFile} describing population structure. If provided, additional layers on the map will be available representing population structure.}

\item{gdsFile}{char The GDS file created in the preprocessing of sambada. If null, will try with \code{envFile}(without -env.csv) and .gds}

\item{markerName}{name of the marker to be plotter if \code{mapType} is 'marker' or 'AS'. \code{markerName} can be found in preparedOutput$sambadaOutput[,''] where preparedOutput would be the result of the function \code{prepareOutput}}

\item{mapType}{char A string or vector of string containing one or several of 'marker' (presence/absence of marker), 'env' (environmental variable distribution), 'popStr' (population variable on continuous scale), 'popPieChart' (belonging to a population in pie charts), 'AS' (autocorrelation of the marker). Note that the background of all maps, if found, will be the raster of the environmental variable. Thus the 'env' \code{mapType} is preferred when no raster is provided. For the 'AS' type, it is calculated on the fly for the markers provided and not the one possibly calculated by sambada.}

\item{varEnvName}{char Name of the environmental variable. If a raster of the variable is located in your working directory, you can provide \code{varEnvName} even for \code{mapType} such as 'marker' or 'AS'. The function will scan the folder of your working directory for raster with the same name as \code{varEnvName} (and commonly used extension for raster) and put it as background.}

\item{SAMethod}{char If \code{mapType} contains 'AS', then you must specify the method for setting the weights of neighbours. Can be one of 'knn' (k-nearest neighbours) or 'distance'}

\item{SAThreshold}{char If \code{mapType} contains 'AS' and \code{SAMethod} is 'knn' then the number of neighbours. If \code{SAMethod} is 'distance' then the distance in map-unit (unless you use a spherical projection (latitude/longitude), in which case you should use km)}

\item{saveType}{char One of NULL, 'png' or 'pdf'. If NULL is set, the maps will be shown in the R plotting window. Otherwise, it will be saved in the specified format in your working directory.}

\item{rasterName}{char If a raster file with the environmental variable distribution exists with a different name than \code{varEnvName}, provide it here (including extension)}

\item{simultaneous}{boolean If TRUE and \code{mapType} contains several kinds of maps, all maps corresponding to the same marker will be plotted on the same window. The resulting maps can be very small.}
}
\value{
None
}
\description{
Plots several kinds of maps (environmental variable distribution, population structure, marker absence or presence, autocorrelation of marker). Unlike \code{\link{plotResultInteractive}}, the resulting maps are non-interactive. The function can handle several marker/variables at once and create separate output files.
}
\examples{
# Define right GDS file according to your OS
if(Sys.info()['sysname']=='Windows'){
  gdsFile=system.file("extdata", "uganda-subset-mol_windows.gds", package = "R.SamBada")
} else {
  gdsFile=system.file("extdata", "uganda-subset-mol_unix.gds", package = "R.SamBada")
}
#############
# Run plotMap
#############
# Map of environmental variable
\donttest{
plotMap(envFile=system.file("extdata", "uganda-subset-env-export.csv", package = "R.SamBada"), 
     x='longitude', y='latitude', locationProj=4326,  popStrCol='pop1', gdsFile=gdsFile, 
     markerName='Hapmap28985-BTA-73836_GG', mapType='env', varEnvName='bio1', 
     simultaneous=FALSE)

plotMap(envFile=system.file("extdata", "uganda-subset-env-export.csv", package = "R.SamBada"), 
     x='longitude', y='latitude', locationProj=4326,  popStrCol='pop1', gdsFile=gdsFile, 
     markerName='Hapmap28985-BTA-73836_GG', mapType='marker', varEnvName='bio1', 
     simultaneous=FALSE)

# Maps of marker and population structure (two subplot)
plotMap(envFile=system.file("extdata", "uganda-subset-env-export.csv", package = "R.SamBada"),
     'longitude','latitude', locationProj=4326,  popStrCol='pop1', 
     gdsFile=gdsFile, markerName='Hapmap28985-BTA-73836_GG', 
     mapType=c('marker', 'popStr'), varEnvName='bio1', simultaneous=TRUE)
}
}
\author{
Solange Duruz
}
