% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_RGWAS.R
\name{score.calc.MC}
\alias{score.calc.MC}
\title{Calculate -log10(p) for single-SNP GWAS (multi-cores)}
\usage{
score.calc.MC(
  M.now,
  ZETA.now,
  y,
  X.now,
  package.MM = "gaston",
  Hinv,
  n.core = 2,
  parallel.method = "mclapply",
  P3D = TRUE,
  eigen.G = NULL,
  optimizer = "nlminb",
  min.MAF = 0.02,
  count = TRUE
)
}
\arguments{
\item{M.now}{A \eqn{n \times m} genotype matrix where \eqn{n} is sample size and \eqn{m} is the number of markers.}

\item{ZETA.now}{A list of variance (relationship) matrix (K; \eqn{m \times m}) and its design matrix (Z; \eqn{n \times m}) of random effects. You can use only one kernel matrix.
For example, ZETA = list(A = list(Z = Z, K = K))
Please set names of list "Z" and "K"!}

\item{y}{A \eqn{n \times 1} vector. A vector of phenotypic values should be used. NA is allowed.}

\item{X.now}{A \eqn{n \times p} matrix. You should assign mean vector (rep(1, n)) and covariates. NA is not allowed.}

\item{package.MM}{The package name to be used when solving mixed-effects model. We only offer the following three packages: 
"RAINBOWR", "MM4LMM" and "gaston". Default package is `gaston`.
See more details at \code{\link{EM3.general}}.}

\item{Hinv}{The inverse of \eqn{H = ZKZ' + \lambda I} where \eqn{\lambda = \sigma^2_e / \sigma^2_u}.}

\item{n.core}{Setting n.core > 1 will enable parallel execution on a machine with multiple cores. 
This argument is not valid when `parallel.method = "furrr"`.}

\item{parallel.method}{Method for parallel computation. We offer three methods, "mclapply", "furrr", and "foreach". 

When `parallel.method = "mclapply"`, we utilize \code{\link[pbmcapply]{pbmclapply}} function in the `pbmcapply` package 
with `count = TRUE` and \code{\link[parallel]{mclapply}} function in the `parallel` package with `count = FALSE`. 

When `parallel.method = "furrr"`, we utilize \code{\link[furrr]{future_map}} function in the `furrr` package. 
With `count = TRUE`, we also utilize \code{\link[progressr]{progressor}} function in the `progressr` package to show the progress bar, 
so please install the `progressr` package from github (\url{https://github.com/HenrikBengtsson/progressr}). 
For `parallel.method = "furrr"`, you can perform multi-thread parallelization by 
sharing memories, which results in saving your memory, but quite slower compared to `parallel.method = "mclapply"`.

When `parallel.method = "foreach"`, we utilize \code{\link[foreach]{foreach}} function in the `foreach` package 
with the utilization of \code{\link[parallel]{makeCluster}} function in `parallel` package, 
and \code{\link[doParallel]{registerDoParallel}} function in `doParallel` package. 
With `count = TRUE`, we also utilize \code{\link[utils]{setTxtProgressBar}} and 
\code{\link[utils]{txtProgressBar}} functions in the `utils` package to show the progress bar.

We recommend that you use the option `parallel.method = "mclapply"`, but for Windows users, 
this parallelization method is not supported. So, if you are Windows user, 
we recommend that you use the option `parallel.method = "foreach"`.}

\item{P3D}{When P3D = TRUE, variance components are estimated by REML only once, without any markers in the model.
When P3D = FALSE, variance components are estimated by REML for each marker separately.}

\item{eigen.G}{A list with
\describe{
\item{$values}{Eigen values}
\item{$vectors}{Eigen vectors}
}
The result of the eigen decompsition of \eqn{G = ZKZ'}. You can use "spectralG.cpp" function in RAINBOWR.
If this argument is NULL, the eigen decomposition will be performed in this function.
We recommend you assign the result of the eigen decomposition beforehand for time saving.}

\item{optimizer}{The function used in the optimization process. 
We offer "optim", "optimx", and "nlminb" functions. 
This argument is only valid when `package.MM = 'RAINBOWR'`.}

\item{min.MAF}{Specifies the minimum minor allele frequency (MAF).
If a marker has a MAF less than min.MAF, it is assigned a zero score.}

\item{count}{When count is TRUE, you can know how far RGWAS has ended with percent display.}
}
\value{
-log10(p) for each marker
}
\description{
Calculate -log10(p) of each SNP by the Wald test.
}
\references{
Kennedy, B.W., Quinton, M. and van Arendonk, J.A. (1992)
Estimation of effects of single genes on quantitative traits. J Anim Sci. 70(7): 2000-2012.

Kang, H.M. et al. (2008) Efficient Control of Population Structure
 in Model Organism Association Mapping. Genetics. 178(3): 1709-1723.

Kang, H.M. et al. (2010) Variance component model to account for sample
  structure in genome-wide association studies. Nat Genet. 42(4): 348-354.

Zhang, Z. et al. (2010) Mixed linear model approach adapted for genome-wide
 association studies. Nat Genet. 42(4): 355-360.
}
