% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getC.r
\name{getC}
\alias{getC}
\title{Imports common dataset file types into R environment}
\usage{
getC(file, confirm = TRUE, ...)
}
\arguments{
\item{file}{(Optional) Path to file you want to get and load in your R session; if you do not specify file you will be prompted to select one.}

\item{confirm}{(Optional) Do you want to confirm getting file before function results returned? (default: TRUE)}

\item{...}{(Optional) Additional arguments passed to loading function}
}
\value{
Dataset specified in file argument as a data frame. You must assign this returned data frame to an object to work with it.
}
\description{
If you don't complete file argument, you will be prompted to select file. Supports dataset file format like Stata, SPSS, Rdata, and csv files. It previews imported data and asks you to confirm before returning a data frame. You must assign the returned data frame to an object to work with it. If \code{getC} doesn't support a file type, it may suggest other functions and packages for importing that type of file.
}
\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 15.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp. 321-327. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=15}{R Tutorials & Resources for Doing Your Own Political Analysis}, Compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
   library(RCPA3)
   
   # basic call will prompt user to choose file
   \dontrun{ 
   getC()
   }
}
