% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.significance.R
\name{global.significance}
\alias{global.significance}
\title{Global significance test}
\usage{
global.significance(
  X,
  Y,
  Z,
  ntree = 200,
  mtry = NULL,
  nperm = 500,
  nodesize = NULL,
  nodedepth = NULL,
  nsplit = 10,
  Xcenter = TRUE,
  Ycenter = TRUE
)
}
\arguments{
\item{X}{The first multivariate data set which has \eqn{n} observations and
\eqn{px} variables. A data.frame of numeric values.}

\item{Y}{The second multivariate data set which has \eqn{n} observations and
\eqn{py} variables. A data.frame of numeric values.}

\item{Z}{The set of subject-related covariates which has \eqn{n} observations
and \eqn{pz} variables. Used in random forest growing. A data.frame with
numeric values and factors.}

\item{ntree}{Number of trees.}

\item{mtry}{Number of z-variables randomly selected as candidates for
splitting a node. The default is \eqn{pz/3} where \eqn{pz} is the number of
z variables. Values are always rounded up.}

\item{nperm}{Number of permutations.}

\item{nodesize}{Forest average number of unique data points in a terminal
node. The default is the \eqn{3 * (px+py)} where \eqn{px} and \eqn{py} are
the number of x and y variables, respectively.}

\item{nodedepth}{Maximum depth to which a tree should be grown. In the
default, this parameter is ignored.}

\item{nsplit}{Non-negative integer value for the number of random splits to
consider for each candidate splitting variable. When zero or \code{NULL},
all possible splits considered.}

\item{Xcenter}{Should the columns of X be centered? The default is
\code{TRUE}.}

\item{Ycenter}{Should the columns of Y be centered? The default is
\code{TRUE}.}
}
\value{
An object of class \code{(rfcca,globalsignificance)} which is a list
with the following components:

\item{call}{The original call to \code{global.significance}.}
\item{pvalue}{\emph{p}-value, see below for details.}
\item{n}{Sample size of the data (\code{NA}'s are omitted).}
\item{ntree}{Number of trees grown.}
\item{nperm}{Number of permutations.}
\item{mtry}{Number of variables randomly selected for splitting at each
node.}
\item{nodesize}{Minimum forest average number of unique data points in a
terminal node.}
\item{nodedepth}{Maximum depth to which a tree is allowed to be grown.}
\item{nsplit}{Number of randomly selected split points.}
\item{xvar}{Data frame of x-variables.}
\item{xvar.names}{A character vector of the x-variable names.}
\item{yvar}{Data frame of y-variables.}
\item{yvar.names}{A character vector of the y-variable names.}
\item{zvar}{Data frame of z-variables.}
\item{zvar.names}{A character vector of the z-variable names.}
\item{predicted.oob}{OOB predicted canonical correlations for training
observations based on the selected final canonical correlation estimation
method.}
\item{predicted.perm}{Predicted canonical correlations for the permutations.
A matrix of predictions with observations on the ows and permutations on
the columns.}
}
\description{
This function runs a permutation test to evaluates the global effect of
subject-related covariates (Z). Returns an estimated \emph{p}-value.
}
\section{Details}{

We perform a hypothesis test to evaluate the global effect of the
subject-related covariates on distinguishing between canonical correlations.
Define the unconditional canonical correlation between \eqn{X} and
\eqn{Y} as \eqn{\rho_{CCA}(X,Y)} which is found by computing CCA with
all \eqn{X} and \eqn{Y}, and the conditional canonical correlation between
\eqn{X} and \eqn{Y} given \eqn{Z} as \eqn{\rho(X,Y | Z)} which is found by
\code{rfcca()}. If there is a global effect of \eqn{Z} on correlations
between \eqn{X} and \eqn{Y}, \eqn{\rho(X,Y | Z)} should be significantly
different from \eqn{\rho_{CCA}(X,Y)}. We conduct a permutation test
for the null hypothesis \deqn{H_0 : \rho(X,Y | Z) = \rho_{CCA}(X,Y)}
We estimate a \emph{p}-value with the permutation test. If the \emph{p}-value is
less than the pre-specified significance level \eqn{\alpha}, we reject the
null hypothesis.
}

\examples{
\donttest{
## load generated example data
data(data, package = "RFCCA")
set.seed(2345)

global.significance(X = data$X, Y = data$Y, Z = data$Z, ntree = 40,
  nperm = 5)
}

}
\seealso{
\code{\link{rfcca}}
\code{\link{predict.rfcca}}
\code{\link{print.rfcca}}
}
