% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_in_gr.R
\name{is_in_gr}
\alias{is_in_gr}
\title{is_in_gr}
\usage{
is_in_gr(Y, cutoff = 0.999, theta.mu, theta.sigma)
}
\arguments{
\item{Y}{A matrix of size n x p.}

\item{cutoff}{quantiles of chi-square to be used as a threshold for outliers 
detection, defaults to 0.999}

\item{theta.mu}{The estimated centers: A list with K elements, each of them 
is an array of length p.}

\item{theta.sigma}{The estimated scatter matrices: A list with K matrices, each of them 
has dimension p x p}
}
\value{
A boolean vector of length n, true at j-th location indicates that the 
j-th element of Y is a regular observation (that is, it is not considered as an outlier)
}
\description{
Given Y  data  and a set of mixture parameters, this function
returns a  boolean vector B whose length is equal than Y length.
A[i] is TRUE if only if Y[i] does not belong to the  union of
confidence ellipsoids of level given by the cutoff parameter.
}
