# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Ordinary Least Squares
#' 
#' Fits the standard OLS model.
#' 
#' @param y Nx1 Numeric vector.
#' @param X NxP Numeric matrix.
#' 
#' @return List containing the following:
#' \item{Beta}{Regression coefficient.}
#' \item{V}{Outcome variance.}
#' \item{Ibb}{Information matrix for beta.}
#' \item{Resid}{Outcome residuals.}
fitOLS <- function(y, X) {
    .Call(`_RNOmni_fitOLS`, y, X)
}

#' Matrix Inner Product
#'
#' Calculates the product \eqn{A'B}.
#'
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @return Numeric matrix.
matIP <- function(A, B) {
    .Call(`_RNOmni_matIP`, A, B)
}

#' Matrix Inverse
#' 
#' Calcualtes \eqn{A^{-1}}.
#'
#' @param A Numeric matrix.
#' @return Numeric matrix. 
matInv <- function(A) {
    .Call(`_RNOmni_matInv`, A)
}

#' Schur complement
#'
#' Calculates the efficient information \eqn{I_{bb}-I_{ba}I_{aa}^{-1}I_{ab}}. 
#'
#' @param Ibb Information of target parameter
#' @param Iaa Information of nuisance parameter
#' @param Iba Cross information between target and nuisance parameters
#' @return Numeric matrix. 
SchurC <- function(Ibb, Iaa, Iba) {
    .Call(`_RNOmni_SchurC`, Ibb, Iaa, Iba)
}

