% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODBCResult.R
\docType{methods}
\name{odbc-meta}
\alias{dbColumnInfo,ODBCResult-method}
\alias{dbGetInfo,ODBCResult-method}
\alias{dbGetRowCount,ODBCResult-method}
\alias{dbGetStatement,ODBCResult-method}
\alias{odbc-meta}
\title{Database interface meta-data.}
\usage{
\S4method{dbGetRowCount}{ODBCResult}(res, ...)

\S4method{dbGetStatement}{ODBCResult}(res, ...)

\S4method{dbGetInfo}{ODBCResult}(dbObj, ...)

\S4method{dbColumnInfo}{ODBCResult}(res, ...)
}
\arguments{
\item{res}{An object of class \code{\linkS4class{ODBCResult}}}

\item{...}{Ignored. Needed for compatibility with generic}

\item{dbObj}{An object inheriting from \code{\linkS4class{ODBCConnection}}, \code{\linkS4class{ODBCDriver}}, or a \code{\linkS4class{ODBCResult}}}
}
\description{
See documentation of generics for more details.
}
\examples{
\dontrun{
library(DBI)
data(USArrests)
con <- dbConnect(RODBCDBI::ODBC(), dsn="test", user="sa", password="Password12!")
dbWriteTable(con, "t1", USArrests, overwrite=TRUE)
dbWriteTable(con, "t2", USArrests, overwrite=TRUE)

dbListTables(con)

rs <- dbSendQuery(con, "select * from t1 where UrbanPop >= 80")
dbGetStatement(rs)
dbHasCompleted(rs)

info <- dbGetInfo(rs)
names(info)
info$fields

dbFetch(rs, n=2)
dbHasCompleted(rs)
info <- dbGetInfo(rs)
info$fields
dbClearResult(rs)

# DBIConnection info
names(dbGetInfo(con))

dbDisconnect(con)
}
}

