% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPtest_single.R
\name{RPtest_single}
\alias{RPtest_single}
\title{Test significance of single predictors}
\usage{
RPtest_single(x, y, x_alt, B = 100L, rand_gen = rnorm, mc.cores = 1L)
}
\arguments{
\item{x}{Input matrix with \code{nobs} rows, each an observation vector.}

\item{y}{Response variable; shoud be a numeric vector.}

\item{x_alt}{Optional: a matrix with jth column the sparse projection of the
jth column of x on all its other columns i.e. the output of
\code{\link{sparse_proj}}. If not supplied this is computed by the
function.}

\item{B}{Number of bootstrap samples. If set to 0, the asymptotic ditribution
is used for calibration.}

\item{rand_gen}{A function to generate the simulated errors up to an unknown
scale factor. It must permit calling as \code{rand_gen(nobs*B)}. Determines
the form of errors in each of the null models, though the results are
broadly insensitive to this choice. The default \code{rnorm} equates to
null hypotheses of (sparse) Gaussian linear models. Setting
\code{rand_gen=NULL} resamples residuals to generate simulated errors and
approximates nulls of i.i.d. errors with unknown distributions.}

\item{mc.cores}{Number of cores to use.}
}
\value{
A vector of p-values for each variable.
}
\description{
Compute p-values for the significance of each variable in \code{x}.
}
\examples{
x <- scale(matrix(rnorm(50*100), 50, 100))
x <- scale(x)
y <- as.numeric(x[, 1:5] \%*\% rep(1, 5) + rnorm(nrow(x)))
out <- RPtest_single(x=x, y=y, B=25)
}
\references{
Shah, R. D., Buhlmann, P. (2017) \emph{Goodness of fit tests for
  high-dimensional linear models} \url{https://rss.onlinelibrary.wiley.com/doi/10.1111/rssb.12234}
}
\seealso{
\code{\link{RPtest}} and \code{\link{sparse_proj}}
}
