% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boost.R
\name{Boost.control}
\alias{Boost.control}
\title{Tuning and control parameters for the robust boosting algorithm}
\usage{
Boost.control(
  n_init = 100,
  eff_m = 0.95,
  bb = 0.5,
  trim_prop = NULL,
  trim_c = 3,
  max_depth_init = 3,
  min_leaf_size_init = 10,
  cal_imp = TRUE,
  save_f = FALSE,
  make_prediction = TRUE,
  save_tree = FALSE,
  precision = 4,
  shrinkage = 1,
  trace = FALSE
)
}
\arguments{
\item{n_init}{number of iterations for the SBoost step of RRBoost ($T_{1,max}$) (int)}

\item{eff_m}{scalar between 0 and 1 indicating the efficiency (measured in a linear model with Gaussian errors) of Tukey's loss function used in the 2nd stage of RRBoost.}

\item{bb}{breakdown point of the M-scale estimator used in the SBoost step (numeric)}

\item{trim_prop}{trimming proportion if 'trmse' is used as the performance metric (numeric). 'trmse' calculates the root-mean-square error of residuals (r) of which |r| < quantile(|r|, 1-trim_prop)  (e.g. trim_prop = 0.1 ignores 10\% of the data and calculates RMSE of residuals whose absolute values are below 90\% quantile of |r|). If  both \code{trim_prop} and \code{trim_c} are specified, \code{trim_c} will be used.}

\item{trim_c}{the trimming constant if 'trmse' is used as the performance metric (numeric, defaults to 3). 'trmse' calculates the root-mean-square error of the residuals (r) between median(r) + trim_c mad(r) and median(r) - trim_c mad(r).  If  both \code{trim_prop} and \code{trim_c} are specified, \code{trim_c} will be used.}

\item{max_depth_init}{the maximum depth of the initial LADTtree  (numeric, defaults to 3)}

\item{min_leaf_size_init}{the minimum number of observations per node of the initial LADTtree (numeric, defaults to 10)}

\item{cal_imp}{logical indicating whether to calculate variable importance  (defaults to \code{TRUE})}

\item{save_f}{logical indicating whether to save the function estimates at all iterations (defaults to \code{FALSE})}

\item{make_prediction}{logical indicating whether to make predictions using \code{x_test} (defaults to \code{TRUE})}

\item{save_tree}{logical indicating whether to save trees at all iterations  (defaults to \code{FALSE})}

\item{precision}{number of significant digits to keep when using validation error to calculate early stopping time (numeric, defaults to 4)}

\item{shrinkage}{shrinkage parameter in boosting (numeric, defaults to 1 which corresponds to no shrinkage)}

\item{trace}{logical indicating whether to print the number of completed iterations and for RRBoost the completed combinations of LADTree hyperparameters for monitoring progress (defaults to \code{FALSE})}
}
\value{
A list of all input parameters
}
\description{
Tuning and control parameters for the RRBoost robust boosting algorithm, including the initial fit.
}
\details{
Various tuning and control parameters for the RRBoost robust boosting algorithm implemented in the
function \code{\link{Boost}},  including options for the initial fit.
}
\examples{
data(airfoil)
n <- nrow(airfoil)
n0 <- floor( 0.2 * n )
set.seed(123)
idx_test <- sample(n, n0)
idx_train <- sample((1:n)[-idx_test], floor( 0.6 * n ) )
idx_val <- (1:n)[ -c(idx_test, idx_train) ]
xx <- airfoil[, -6]
yy <- airfoil$y
xtrain <- xx[ idx_train, ]
ytrain <- yy[ idx_train ]
xval <- xx[ idx_val, ]
yval <- yy[ idx_val ]
xtest <- xx[ idx_test, ]
ytest <- yy[ idx_test ]
my.control <- Boost.control(max_depth_init = 2,
    min_leaf_size_init = 20, make_prediction =  TRUE,
    cal_imp = FALSE)
model_RRBoost_LADTree = Boost(x_train = xtrain, y_train = ytrain,
    x_val = xval, y_val = yval, x_test = xtest, y_test = ytest,
    type = "RRBoost", error = "rmse", y_init = "LADTree",
    max_depth = 1, niter = 10, ## to keep the running time low
    control = my.control)

}
\author{
Xiaomeng Ju, \email{xmengju@stat.ubc.ca}
}
