% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_psi_mu.R
\name{get_psi_mu}
\alias{get_psi_mu}
\title{Auxiliary function for the computation of the eigenvalues of the SVD of F_c}
\usage{
get_psi_mu(c1, N2, twoN, K1, L1)
}
\arguments{
\item{c1}{parameter indexing the SVC}

\item{N2}{maximal number of elements of the SVD that are computed.}

\item{twoN}{number of  Legendre polynomials that are loaded}

\item{K1}{order of the Legendre quadrature}

\item{L1}{number of Legendre polynomials used in the computation}
}
\value{
a list containing, in order:
}
\description{
This function compute the  eigenvalues of the SVD of F_c.
}
\examples{
library(orthopolynom)
library(polynom)
library(tmvtnorm)
library(ks)
library(sfsmisc)
library(snowfall)
library(fourierin)
library(rdetools)
library(statmod)
library(RCEIM)
library(robustbase)
library(VGAM)
library(RandomCoefficients)
#### Number of Psis
L =15
L1 = L+1
N2 = max(L,3)
twoN = 2*N2
#### Bandwidth 1
c1 = 1
K1 = max(twoN+2,30)
K = K1
### get the beta's (for the computation of Psi)
out <- get_psi_mu(c1,N2,twoN,K1, L1)
Psi1 <- out[[1]]
mu1<- out[[2]]
}
