% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_process.R
\name{pre_process}
\alias{pre_process}
\title{Standardize the given data matrix per column, over the rows, with multiple imputation for missing data.}
\usage{
pre_process(DATA, weight)
}
\arguments{
\item{DATA}{A data matrix}

\item{weight}{Whether the data matrix is weighted. \code{weight = TRUE} indicates that the data is weighted. Default is \code{weight = FALSE}.}
}
\value{
a standardized matrix
}
\description{
Standardize the given data matrix per column, over the rows, with multiple imputation for missing data.
}
\note{
Weighting a data matrix (i.e., \code{weight = TRUE}) is performed as follows. Each cell in the data is devided by the sqaure root of the number of variables. 

More details regarding data pre-processing, please see:

Van Deun, K., Smilde, A.K., van der Werf, M.J., Kiers, H.A.L., & Mechelen, I.V. (2009). A structured overview of simultaneous component based data integration. \emph{BMC Bioinformatics}, 10:246.

The missing values are handled by means of Multivariate Imputation by Chained Equations (MICE). The number of multiple imputation is 5. More details see:

Buuren, S. V., & Groothuis-Oudshoorn, K. (2010). mice: Multivariate imputation by chained equations in R. \emph{Journal of statistical software}, 1-68.
}
\examples{
\dontrun{
pre_process(matrix(1:12, nrow = 3, ncol = 4))
}
}
