% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_database_setup.R
\name{mod_database_setup}
\alias{mod_database_setup}
\alias{database_setup_ui}
\alias{database_setup_server}
\title{Database Module Selector}
\usage{
database_setup_ui(id)

database_setup_server(id)
}
\arguments{
\item{id}{The Module namespace}
}
\value{
\emph{database_setup_ui}:
\item{tagList}{A tagList containing a selectInput that allows for selection of
available database setup modules and the setup UI for the selected database
module.}
\emph{database_setup_server}:
\item{reactiveValues}{This module has no returns of its own, but will pass on
the \code{reactiveValues} returns from the user selected database module.}
}
\description{
This module allows the user to select an available ReviewR database module
from a dropdown list. It dynamically returns the database setup UI and user
configured database connection information from the selected module.

See \code{vignette("customize_support_new_rdbms", package = "ReviewR")} for more
information on database modules and how to add support for additional databases.

This module consists of the following components:
\subsection{Module UI function}{

\itemize{
\item{\code{database_setup_ui}}: A tagList with a dropdown selector containing
available database modules.
}
}

\subsection{Module Server function}{

\itemize{
\item{\code{database_setup_server}}: Processes user selection and dynamically returns
a uiOutput for the selected database module's setup UI. Any returns from the
configured database connection module are captured and returned.
}
}
}
\keyword{internal}
