% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveRev.R
\name{saveRev}
\alias{saveRev}
\title{Save Revticulate History}
\usage{
saveRev(filepath, use_wd = TRUE, use_quit = TRUE)
}
\arguments{
\item{filepath}{character - Location of the .Rev file to save Revticulate history in. If the file doesn't exist, it will be created. Otherwise, it will be overwritten.}

\item{use_wd}{logical - If TRUE, the history will be prepended by setwd({'users current working directory'}). This function will set the script's working directory to
the user's current working directory, which is often desirable for files that will be submitted to callRevFromTerminal() and contain output moniters.}

\item{use_quit}{logical - If TRUE, q() will be appended to the end of the history before writing it to a file.
This will cause the RevBayes session to quit after evaluating the script's code, and is good practice
when running an mcmc in an RStudio terminal.}
}
\description{
Captures the current Revticulate history and saves it to an external file.
}
\details{
By providing a file path, the user can save the RevBayes code in their current
Revticulate session to an external .Rev script.
This script can then be executed in RevBayes via source(),
or in an RStudio terminal via callRevFromTerminal().
Usage of this function can be combined with loadRev() to allow
for the continual use of a Revticulate history instance between R sessions.
}
\examples{
\dontrun{
      saveRev("mySavedCode.rev", use_quit=FALSE)
      saveRev("mySavedCode.rev", use_wd=FALSE, use_quit=TRUE)
}


}
