% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnvd3-shiny.R
\name{rnvd3-shiny}
\alias{rnvd3-shiny}
\alias{rnvd3Output}
\alias{renderRnvd3}
\title{Shiny bindings for rnvd3}
\usage{
rnvd3Output(outputId, width = "100\%", height = "400px")

renderRnvd3(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended}

\item{expr}{an expression that generates a \code{rnvd3} widget}

\item{env}{the environment in which to evaluate \code{expr}}

\item{quoted}{is \code{expr} a quoted expression (with \code{quote()})}
}
\value{
\code{rnvd3Output} returns an output element that can be included
  in a Shiny UI definition, and \code{renderRnvd3} returns a
  \code{shiny.render.function} object that can be included in a Shiny server
  definition.
}
\description{
Output and render functions for using \code{rnvd3} widgets
  within Shiny applications and interactive Rmd documents.
}
\examples{
library(Rnvd3)
library(shiny)

dat <- reshape2::melt(
  apply(HairEyeColor, c(1, 2), sum), value.name = "Count"
)

CSS <- HTML(
  "body {
    overflow: overlay;
  }
  /* style axis titles */
  .nvd3 .nv-axis.nv-x text.nv-axislabel,
   .nvd3 .nv-axis.nv-y text.nv-axislabel {
     font-size: 3rem;
     fill: red;
  }
  /* style the tooltip */
  .nvtooltip .value {
    color: red;
  }
  .nvtooltip .x-value {
    color: green;
  }
  .nvtooltip .key {
    color: blue;
    font-style: italic;
  }
  "
)

ui <- fluidPage(
  tags$head(tags$style(CSS)),
  br(),
  fluidRow(
    column(
      9,
      rnvd3Output("mychart", width = "100\%", height = "500px")
    ),
    column(
      3,
      tags$h3("Chart state:"),
      verbatimTextOutput("state")
    )
  )
)

server <- function(input, output, session){

  output[["mychart"]] <- renderRnvd3({
    multiBarChart(
      dat, Count ~ Eye, "Hair", palette = "viridis",
      xLabelsFontSize = "2rem", yLabelsFontSize = "2rem"
    )
  })

  output[["state"]] <- renderPrint({
    input[["mychart_state"]]
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
