% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancel_order_crypto.R
\name{cancel_order_crypto}
\alias{cancel_order_crypto}
\title{Cancel an existing crypto order on RobinHood}
\usage{
cancel_order_crypto(RH, cancel_url)
}
\arguments{
\item{RH}{object of class RobinHood}

\item{cancel_url}{(string) cancel url returned from place_order_crypto()}
}
\description{
Send a cancel signal for a particular order to RobinHood. You will need to retain the buy/sell order url returned from place_order.
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

# Place an order, should generate an email confirmation
x <- place_order_crypto(RH = RH,
                        symbol = "ETC",         # Ticker symbol
                        type = "market",        # Type of market order (market, limit)
                        time_in_force = "gtc",  # Time period (gfd: good for day)
                        price = 1,              # The highest price you are willing to pay
                        quantity = 1,           # Number of shares you want
                        side = "buy")           # buy or sell

# Cancel the order, should also generate an email confirmation
cancel_order_crypto(RH, x$cancel_url)
}
}
