% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancel_order_options.R
\name{cancel_order_options}
\alias{cancel_order_options}
\title{Cancel an existing options order on RobinHood}
\usage{
cancel_order_options(RH, cancel_url)
}
\arguments{
\item{RH}{object of class RobinHood}

\item{cancel_url}{(string) cancel url returned from place_order()}
}
\description{
Send a cancel signal for a particular order to RobinHood. You will need to retain the buy/sell order url returned
from place_order_options().
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

# Place an order, should generate an email confirmation
x <- place_order_options(RH = RH,
                       option_id = "346e46af-380e-4052-a7c2-15748f0fc0ca",
                       direction = "debit",   # one of "debit" or "credit"
                       side = "buy",          # one of "buy" or "sell"
                       quantity = 1,          # number of contracts
                       stop_price = .01,      # Time period (gfd: good for day)
                       type = "limit",        # limit or market (only limit is currently supported)
                       time_in_force = "gtc") # "gfd", "gtc", "ioc", "opg"

# Cancel the order, should also generate an email confirmation
cancel_order_options(RH, x$cancel_url)
}
}
