% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rpvt-package.R
\name{pvt_gas}
\alias{pvt_gas}
\title{Create a matrix of PVT properties for dry- and wet-gas samples}
\usage{
pvt_gas(
  input_unit = "Field",
  output_unit = "Field",
  fluid = "wet_gas",
  pvt_model = "DAK",
  visc_model = "Sutton",
  t = 300,
  p = 5000,
  gas_spgr = 0.69,
  nhc_composition = c(0, 0, 0),
  cgr = 3,
  cond_api = 42,
  warning = "yes"
)
}
\arguments{
\item{input_unit}{input unit system for parameters, a character string either 'SI' or 'Field'}

\item{output_unit}{output unit system for properties, a character string either 'SI' or 'Field'}

\item{fluid}{fluid type, a character string either 'dry_gas' or 'wet_gas'}

\item{pvt_model}{PVT model, the character string 'DAK'}

\item{visc_model}{viscosity model, the character string 'Sutton'}

\item{t}{temperature, a numeric value either in 'C' or 'F' depending on the 'input_unit'}

\item{p}{pressure, a numeric value either in 'kPag' or 'Psig' depending on the 'input_unit'}

\item{gas_spgr}{gas specific gravity (Air = 1.0)}

\item{nhc_composition}{a vector of mole fractions for nitrogen, hydrogen sulfide, and carbon dioxide, respectively}

\item{cgr}{condensate to gas ratio, a numeric value in 'm3/m3' or 'STB/MMSCF' depending on the 'input_unit'}

\item{cond_api}{condensate API}

\item{warning}{a charater string either 'yes' or 'no'}
}
\description{
The pvt_gas() generates a table of gas PVT properties at reservoir temperature and pressures from the atmospheric condition up to the initial reservoir pressure. The estimated properties are compressibility factor, formation volume factor, density, compressibility, viscosity, and pseudo-pressure.
}
\examples{
pvt_gas_results_1 <- pvt_gas(input_unit = "Field", output_unit = "Field",
fluid = "dry_gas", pvt_model = "DAK", visc_model = "Sutton",
t = 400, p = 20000, gas_spgr = 0.65, nhc_composition = c(0.05,0.02,0.04),
cgr = 0.0, cond_api = NULL, warning = "yes")

head(pvt_gas_results_1)

pvt_gas_results_2 <- pvt_gas(input_unit = "Field", output_unit = "Field",
fluid = "wet_gas", pvt_model = "DAK", visc_model = "Sutton",
t = 300, p = 20000, gas_spgr = 0.75, nhc_composition = c(0.02,0.05,0.08),
cgr = 10.0, cond_api = 42.4, warning = "yes")

head(pvt_gas_results_2)

}
\references{
\insertRef{Sutton2007}{Rpvt}

\insertRef{Wichert1972}{Rpvt}
}
